<?php namespace App\Http\Controllers;

class WelcomeController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('guest');
	}

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		include(app_path() . '\Classes\phpgrid\jqgrid_dist.php');
		
		// Database config file to be passed in phpgrid constructor
		$db_conf = array( 	
							"type" 		=> 'mysqli', 
							"server" 	=> 'localhost',
							"user" 		=> 'root',
							"password" 	=> '',
							"database" 	=> 'griddemo'
						);

		$g = new \jqgrid($db_conf);

		$opt["caption"] = "Sample Grid";
		$g->set_options($opt);

		$g->table = "clients";
				
		$out = $g->render("list1");
		
		return view('welcome',array('phpgrid_output'=>$out));
	}

}
