var __index = {"config":{"lang":["en"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"]},"docs":[{"location":"index.html","title":"Introduction","text":""},{"location":"index.html#introduction","title":"Introduction","text":""},{"location":"index.html#overview","title":"Overview","text":"<p>Grid 4 PHP Framework is a RAD tool that enables development of PHP based project far more faster. Grid component itself contain a CRUD (create,read,update,delete) function which reduce the repeated work load. It support connection to all major database engines including SQL Server, Oracle, IBM DB2, MySQL, Postgres and others. It has master-detail, subgrid, data grouping, file uploading, excel mode and many other features.</p>"},{"location":"ai-assistant.html","title":"AI Assistant","text":""},{"location":"ai-assistant.html#ai-assistant","title":"AI Assistant","text":""},{"location":"ai-assistant.html#step-1-enter-api-key","title":"Step 1: Enter API Key","text":"<p>First step to use AI Assistant is to enter the API Key. Free API Key can be obtained from Groq Cloud Platform.</p> <p></p>"},{"location":"ai-assistant.html#step-2-enable-in-grid-settings","title":"Step 2: Enable in Grid Settings","text":"<p>Next, you can enable AI Assistant in the DataGrid by the following setting:</p> <pre><code>$g-&gt;set_actions(array(\n                        // ...\n                        \"aiassistant\"=&gt;true,\n                        // ...\n                    )\n                )\n</code></pre> <p>This will show the AI Assistant icon in the toolbar.</p> <p></p>"},{"location":"ai-assistant.html#step-3-using-ai-assistant","title":"Step 3: Using AI Assistant","text":"<p>When you click the AI Assistant button, It will open a chat mode for the DataGrid where you can ask the questions about your data.</p> <p></p>"},{"location":"application-templates.html","title":"Application Templates","text":""},{"location":"application-templates.html#application-templates","title":"Application Templates","text":"<p>We've developed several ready-to-use applications using our PHP DataGrid Framework, which includes built-in features.</p> <p></p>"},{"location":"application-templates.html#authentication-system","title":"Authentication System","text":"<p>Authentication module can be enable from the Settings page of the application.</p> <p></p>"},{"location":"application-templates.html#user-management","title":"User Management","text":"<p>User Management module allows you to create new users for the application. Only Admin user can use this module. You can also assign desired roles from:</p> <ul> <li>Admin (All privileges)</li> <li>Editor (Editing privileges without Settings and User Management)</li> <li>Readonly (Readonly Access)</li> </ul> <p></p>"},{"location":"application-templates.html#understanding-the-code","title":"Understanding the Code","text":"<p>The code structure is kept simple so as to modify and extend as per your needs.</p> <ul> <li>The config.php file contains settings about database connection &amp; others.</li> <li>The modules folder contains the code for all DataGrids. The code of the DataGrids is similar to the one that comes with demos.</li> <li>The theme/layout.php is the main layout file that makes tabs and placed grid.</li> <li>The index.php is the front controller that includes all files.</li> <li>The auth.php is the middleware to manage authenticated access.</li> </ul> <p>This code structure is constantly evolving, keeping it simple and flexible.</p> <p></p>"},{"location":"application-templates.html#how-to-customize","title":"How to Customize","text":"<ul> <li>In order to add or modify any column settings of the DataGrid, Inside <code>modules</code> folder locate the DataGrid code (filename is the same as grid) and change the desired column settings.</li> <li>Sample database structure is used just to make the demos. You can modify it as per your needs using any SQL IDE, like phpMyAdmin. </li> <li>If you need developement &amp; customization services from our technical team, you can contact us back.</li> </ul>"},{"location":"application-templates.html#samples","title":"Samples","text":"<p>We have released five application templates so far, with more coming soon.</p> <ul> <li>Sales CRM</li> <li>Inventory Tracking System</li> <li>Employee Directory</li> <li>Donation Management</li> <li>Expense Tracker</li> </ul>"},{"location":"autocomplete.html","title":"Autocomplete","text":""},{"location":"autocomplete.html#autocomplete","title":"Autocomplete","text":"<p>Steps shows how to integrate database driven type ahead and autocomplete by lookup query.</p>"},{"location":"autocomplete.html#basic-typeahead-single-field","title":"Basic Typeahead (single field)","text":"<p>Step1: Set formatter to autocomplete on desired column</p> <pre><code>$col[\"formatter\"] = \"autocomplete\"; // autocomplete\n</code></pre> <p>Step2: Set format options query. The field in sql aliased 'v' will be shown in list</p> <pre><code>// Fill the name field with query values typeahead\n$col[\"formatoptions\"] = array(  \"sql\"=&gt;\"SELECT name as v FROM clients\",\n                                \"update_field\"=&gt;\"name\");\n</code></pre>"},{"location":"autocomplete.html#autofill-other-field","title":"Autofill other field.","text":"<p>The field 'company' will be filled w.r.t. selected name.</p> <pre><code>$col[\"formatoptions\"] = array(  \"sql\"=&gt;\"SELECT company as k, name as v FROM clients\",\n                                \"update_field\"=&gt;\"company\");\n</code></pre> <p>The field aliased 'k' will be set in the 'updated_field' column (e.g. company)</p>"},{"location":"autocomplete.html#callback-function","title":"Callback function","text":"<p>Connect a callback function that will auto-fill multiple fields &amp; search in both name + id,</p> <pre><code>$col[\"formatoptions\"] = array(  \"sql\"=&gt;\"SELECT *, name as v FROM clients\",\n                                \"search_on\"=&gt;\"concat(name,'-',client_id)\",\n                                \"callback\"=&gt;\"fill_form\");\n</code></pre> <p>and in html part, define callback function.</p> <pre><code>&lt;script&gt;\nfunction fill_form(data)\n{\n    jQuery(\"input[name=gender].FormElement\").val(data.gender);\n    jQuery(\"textarea[name=company].FormElement\").val(data.company);\n\n    jQuery(\"input[name=gender].editable\").val(data.gender);\n    jQuery(\"textarea[name=company].editable\").val(data.company);\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"autocomplete.html#minimum-length-for-autocomplete","title":"Minimum Length for Autocomplete","text":"<p>You can set minimum characters length to trigger autocomplete by:</p> <pre><code>$col[\"formatoptions\"][\"min_length\"] = 1; // defaults to 1\n</code></pre>"},{"location":"autocomplete.html#force-selection","title":"Force Selection","text":"<p>You can also force to select from one of the options, set force_select =&gt; true</p> <pre><code>// callback function\n$col[\"formatoptions\"] = array(  \"sql\"=&gt;\"SELECT *, name as v FROM clients where gender='male' ORDER BY name desc\",\n                                \"search_on\"=&gt;\"concat(name,'-',client_id)\",\n                                \"force_select\"=&gt;true);\n</code></pre> <p>By default, autocomplete uses 'contains' search. To switch to 'begins with' set:</p> <pre><code>$col[\"formatoptions\"][\"op\"] = \"bw\";\n</code></pre>"},{"location":"autocomplete.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/integrations/autocomplete.php</code></li> </ul>"},{"location":"basic-todo-list-application.html","title":"Simple Todo List","text":""},{"location":"basic-todo-list-application.html#basic-todo-list-application","title":"Basic Todo List Application","text":"<p>To show some basic features of php grid framework, we created a very simple demo of todo list and following features are used:</p> <ul> <li>Bootstrap 4 + Mobile sidebar filter menu</li> <li>Conditional Formatting</li> <li>Custom delete event callback for soft delete</li> <li>External Search form (date range, text, priority filters)</li> <li>Checkbox with default edit mode</li> <li>Export to Excel</li> </ul> <p>Desktop screen:</p> <p></p> <p>Mobile screen:</p> <p></p>"},{"location":"basic-todo-list-application.html#resources","title":"Resources","text":"<ul> <li>See Live Demo</li> <li>Source Code</li> </ul>"},{"location":"codeigniter-integration.html","title":"CodeIgniter Integration","text":""},{"location":"codeigniter-integration.html#codeigniter-integration","title":"Codeigniter Integration","text":"<p>We've made a quick walk-through how to integrate the smart PHP DataGrid with CodeIgniter framework. For this, we have used:</p> <ul> <li>Grid 4 PHP Framework 2.9</li> <li>Latest version of CodeIgniter (v4+)</li> <li>PHP 8 (can work on lower supported versions as well)</li> </ul> <p>In this code we used MySQL, however you can use PHP DataGrid combination with almost all famous Database engines including Oracle, Microsoft SQL Server, DB2, Postgres, SQLite, Firebird, etc.</p> <p></p> <p>Steps to integrate are very simple.</p>"},{"location":"codeigniter-integration.html#step-1-download-codeigniter","title":"Step 1:  Download CodeIgniter","text":"<p>Download CodeIgniter archive from  Github repository  and extract it in your public_html / htdocs / similar web public folder of your web server. Make sure it is showing the CI startup page.</p>"},{"location":"codeigniter-integration.html#step-2-download-grid4php","title":"Step 2: Download Grid4PHP","text":"<p>Download the Grid4PHP archive from  our website. You can either use free OR paid version, Comparison is  available here. Free version provides basic essential functions for evaluation purpose.</p>"},{"location":"codeigniter-integration.html#step-3-extract-in-codeigniter-folder","title":"Step 3: Extract in CodeIgniter Folder","text":"<p>Extract the Grid4PHP archive and move the <code>lib</code> folder from archive to the <code>public</code> folder of CodeIgniter.</p>"},{"location":"codeigniter-integration.html#step-4-setup-controller","title":"Step 4: Setup Controller","text":"<p>Replace the code of CI\u2019s Controller <code>app\\Controller\\Home.php</code> with this sample controller code.</p> <p>In Controller, make sure you set the  database configuration  (Line 9-14) and a  table  to fetch data (Line 25), according to your requirement.</p>"},{"location":"codeigniter-integration.html#step-5-setup-view","title":"Step 5: Setup View","text":"<p>In View, include the <code>JS</code> and <code>CSS</code> files and echo variable passed from controller. CI\u2019s View welcome_message can be replaced with this sample view code.</p>"},{"location":"codeigniter-integration.html#step-6-set-routes","title":"Step 6: Set Routes","text":"<p>In Routes.php, Set both POST and GET routes for the controller function.</p>"},{"location":"codeigniter-integration.html#result","title":"Result","text":""},{"location":"codeigniter-integration.html#troubleshooting","title":"Troubleshooting","text":"<ul> <li>Getting \u201cWhoops! We seem to have hit a snag. Please try again later\u201d. If you see this message after setting up, please check the log file of CodeIgniter in \u201cwritable/logs\u201d folder. It will tell the exact reason behind it.</li> <li>Make sure you have \u201cintl\u201d and \u201ccurl\u201d php extensions installed. They are required by CodeIgniter 4.</li> </ul>"},{"location":"column-appearance-faqs.html","title":"Column Appearance FAQs","text":""},{"location":"column-appearance-faqs.html#column-appearance-faqs","title":"Column Appearance FAQs","text":""},{"location":"column-appearance-faqs.html#q-how-can-i-set-the-width-of-actions-column","title":"Q) How can i set the width of 'Actions' column?","text":"<p>You can also customize the width of that column,</p> <pre><code># Customization of Action column width and other properties\n$col = array();\n$col[\"title\"] = \"Action\";\n$col[\"name\"] = \"act\";\n$col[\"width\"] = \"50\";\n$cols[] = $col;\n</code></pre> <p>You can also hide actions column leaving double click operation intact, by setting hidden with column config.</p> <pre><code>$col[\"hidden\"] = true;\n</code></pre> <p>This work when you define grid columns manually and pass to this function. Otherwise, it will distribute all columns with equal width.</p> <pre><code>// pass the cooked columns to grid\n$g-&gt;set_columns($cols);\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-to-show-action-column-on-left-side","title":"Q) How to show Action column on left side?","text":"<p>Make first column (in $cols array) as PK and make $col[\"hidden\"] = true; To make action links on left, define it as 2nd column (in $cols array).</p> <pre><code># Customization of Action column width and other properties\n$col = array();\n$col[\"title\"] = \"Action\";\n$col[\"name\"] = \"act\";\n$col[\"width\"] = \"50\";\n$cols[] = $col;\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-can-i-use-custom-data-formatter-with-column","title":"Q) How can i use custom data formatter with column?","text":"<p>You can use it in following manner, e.g.</p> <p>in php code ...</p> <pre><code>$col = array();\n$col[\"title\"] = \"Closed\";\n$col[\"name\"] = \"closed\";\n$col[\"width\"] = \"50\";\n$col[\"editable\"] = true;\n$col[\"edittype\"] = \"checkbox\"; // render as checkbox\n$col[\"editoptions\"] = array(\"value\"=&gt;\"1:0\"); // with these values \"checked_value:unchecked_value\"\n$col[\"formatter\"] = \"function(cellvalue, options, rowObject){ return cboxFormatter(cellvalue, options, rowObject);}\";\n</code></pre> <p>and in html ...</p> <pre><code>&lt;script&gt;\nfunction cboxFormatter(cellvalue, options, rowObject)\n{\n    return '&lt;input type=\"checkbox\" name=\"itemid[]\" value=\"'+options.rowId+'\" onclick=\"test('+options.rowId+',this.checked);\"/&gt; '+cellvalue;\n}\n&lt;/script&gt;\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre> <p>In custom formatter, rowObject[0] contains first cell data and so on, we can also use some JS based ajax calling on current row.</p> <p>Another example is to show negative numbers in ( ) and red in color.</p> <pre><code>$col[\"formatter\"] = \"function (cellvalue, options) {\n    var value = parseFloat(cellvalue);\n    return (value &gt;= 0 ? value : '(' + value + ')') + ' \u20ac';\n}\";\n\n$col[\"unformat\"] = \"function (cellvalue, options) {\n    return cellvalue.replace('(','').replace(')','').replace(' \u20ac','');\n}\";\n\n$col[\"cellattr\"] = \"function (rowid, cellvalue) {\n    return parseFloat(cellvalue) &gt;= 0 ? '' : ' style=\\\"color:red;font-weight:bold;\\\"'\n}\";\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-to-set-multiline-column-title-for-space-flexibility","title":"Q) How to set Multiline Column title for space flexibility?","text":"<p>Sometimes the title is a bit too long. You can set column title/header with multiline text using linebreak, for example:</p> <pre><code>$col[\"title\"]=\"Total&lt;br&gt;Male\";\n</code></pre> <p>Additionally, you might need to use custom css for better display.</p> <pre><code>&lt;style&gt;\n.ui-jqgrid .ui-jqgrid-htable th div\n{\n    height: 25px;\n    padding: 5px;\n}\n&lt;/style&gt;\n</code></pre> <p>Text Rotation could also be done using css.</p>"},{"location":"column-appearance-faqs.html#q-how-to-use-custom-button-for-add-edit-or-delete-grid-operations","title":"Q) How to use custom button for Add, Edit or Delete grid operations ?","text":"<p>You can invoke small button's on-click event, using jQuery code. Refer following code, where <code>list1</code> is grid id.</p> <pre><code>&lt;input type=\"button\" value=\"Add\" onclick=\"jQuery('#add_list1').click()\"&gt;\n&lt;input type=\"button\" value=\"Edit\" onclick=\"jQuery('#edit_list1').click()\"&gt;\n&lt;input type=\"button\" value=\"Delete\" onclick=\"jQuery('#del_list1').click()\"&gt;\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-to-show-html-tags-in-textarea-and-grid-cells","title":"Q) How to show HTML tags in textarea and grid cells?","text":"<p>Following custom formatter will enable you to show html tags in textarea, as well as in grid.</p> <pre><code>$col[\"edittype\"] = \"textarea\"; // render as textarea on edit\n$col[\"formatter\"] = \"function(cellval,options,rowdata){ return jQuery.jgrid.htmlEncode(cellval); }\";\n$col[\"unformat\"] = \"function(cellval,options,cell){ return jQuery.jgrid.htmlDecode(cellval); }\";\n$cols[] = $col;\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-to-show-paragraphs-of-textarea-in-view-record-dialog","title":"Q) How to show paragraphs of textarea in view record dialog?","text":"<p>Following option will enable you to show paragraph tags in textarea view mode, if entered in edit dialog.  If you already use this grid option, you can append the following function code with your existing callback.</p> <pre><code>$opt[\"view_options\"][\"beforeShowForm\"] = 'function (form) \n                {\n                    // formatter for textarea paragraphs in view dialog\n\n                    var gid = form.selector.replace(\"#ViewGrid_\",\"\");\n                    var colModel = jQuery(\"#\"+gid).jqGrid(\"getGridParam\", \"colModel\"); \n                    if (colModel) {\n                        jQuery(colModel).each(function(i) {\n                            if (colModel[i][\"edittype\"] == \"textarea\")\n                            {\n                                var field = colModel[i][\"name\"];\n                                $(\"#v_\"+field).html($(\"#v_\"+field).html().replaceAll(\"\\n\",\"&lt;p&gt;\"));\n                            }\n                        });\n                    }           \n                }';\n\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-to-hide-or-remove-select-all-checkbox","title":"Q) How to hide or remove select all checkbox?","text":"<p>Use this css to hide select all checkbox, where your grid id is list1.</p> <pre><code>&lt;style&gt;\n#cb_list1 {display:none;}\n&lt;/style&gt;\n</code></pre>"},{"location":"column-appearance-faqs.html#q-how-to-show-placeholder-in-search-auto-filters","title":"Q) How to show placeholder in search auto filters?","text":"<p>Here are the steps:</p> <p>1) Set onload event</p> <pre><code>$opt[\"loadComplete\"] = \"function(ids) { do_onload(ids); }\";\n$grid-&gt;set_options($opt);\n</code></pre> <p>2) Include any placeholder library, e.g.</p> <pre><code>&lt;script src=\"https://mathiasbynens.github.io/jquery-placeholder/jquery.placeholder.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>3) Connect to search field. If your column name is 'name' then search field will have id gs_name.</p> <pre><code>&lt;script&gt;\nfunction do_onload(id)\n{\n    $(\"#gs_name\").attr(\"placeholder\",\"Search Name ...\");\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"column-appearance-faqs.html#q-tooltip-for-cells-based-on-other-columns","title":"Q) Tooltip for cells based on other columns?","text":"<p>You can set custom formatter to set custom tooltip (title attr). For e.g. if you want to have cell with tooltip of column 'company', then formatter would be:</p> <pre><code>$col[\"formatter\"] = \"function(cellvalue, options, rowObject){ return '&lt;div title=\\\"'+rowObject.company+'\\\"&gt;'+cellvalue+'&lt;/div&gt;'; }\";\n</code></pre> <p>Unformat function will also be required for editing raw text:</p> <pre><code>$col[\"unformat\"] = \"function(cellvalue, options, rowObject){ return jQuery.jgrid.stripHtml(cellvalue); }\";\n</code></pre> <p>Column settings:</p> <pre><code>$col = array();\n$col[\"title\"] = \"Company\";\n$col[\"name\"] = \"company\";\n$col[\"editable\"] = true;\n$col[\"edittype\"] = \"textarea\";\n$col[\"editoptions\"] = array(\"rows\"=&gt;2, \"cols\"=&gt;20);\n$cols[] = $col;\n\n$col = array();\n$col[\"title\"] = \"Client Name\";\n$col[\"name\"] = \"name\";\n$col[\"formatter\"] = \"function(cellvalue, options, rowObject){ return '&lt;DIV title=\\\"'+rowObject.company+'\\\"&gt;'+cellvalue+'&lt;/DIV&gt;'; }\";\n$col[\"unformat\"] = \"function(cellvalue, options, rowObject){ return $.jgrid.stripHtml(cellvalue); }\";\n$col[\"editable\"] = true;\n$col[\"width\"] = \"80\";\n$cols[] = $col;\n</code></pre> <p>Full code: http://pastebin.com/ENKjryJ1</p>"},{"location":"column-input-types.html","title":"Column Input Types","text":""},{"location":"column-input-types.html#column-input-types","title":"Column Input Types","text":"<p>This option let us select the control we want to render when editing this field. All possible options are in following snippet. Defaults to <code>text</code>. In <code>editoptions</code> we can set all the possible attributes for this field's control.</p>"},{"location":"column-input-types.html#render-as-textarea-on-edit","title":"Render as textarea on edit","text":"<pre><code>$col[\"edittype\"] = \"textarea\";\n$col[\"editoptions\"] = array(\"rows\"=&gt;2, \"cols\"=&gt;20);\n</code></pre>"},{"location":"column-input-types.html#render-as-checkbox","title":"Render as checkbox,","text":"<p>With these values \"checked_value:unchecked_value\"</p> <pre><code>$col[\"edittype\"] = \"checkbox\";\n$col[\"editoptions\"] = array(\"value\"=&gt;\"Yes:No\");\n</code></pre> <p>To make checkbox already in checked state while adding record</p> <pre><code>$col[\"editoptions\"] = array(\"value\"=&gt;\"Yes:No\", defaultValue=&gt; 'Yes');\n</code></pre> <p>To show column as checkbox on listing,</p> <pre><code>$col[\"formatter\"] = \"checkbox\";\n</code></pre>"},{"location":"column-input-types.html#render-as-textbox","title":"Render as textbox","text":"<p>With size 20, and initial value in textbox to 10</p> <pre><code>$col[\"editoptions\"] = array(\"size\"=&gt;20, \"defaultValue\"=&gt;'10');\n</code></pre>"},{"location":"column-input-types.html#render-as-password-textbox","title":"Render as password textbox","text":"<p>It will render textbox as password box.</p> <pre><code>$col[\"edittype\"] = \"password\";\n</code></pre> <p>To display hidden text (****) on listing instead of plain text, set:</p> <pre><code>$col[\"formatter\"] = \"password\";\n</code></pre>"},{"location":"column-input-types.html#render-as-select-dropdown","title":"Render as select (dropdown)","text":"<p>With these values \"key:value;key:value;key:value\"</p> <pre><code>$col[\"edittype\"] = \"select\";\n$col[\"editoptions\"] = array(\"value\"=&gt;'10:$10;20:$20;30:$30;40:$40;50:$50');\n\n// For multiselect, you probably need to write custom on_update handler\n$col[\"editoptions\"] = array(\"value\"=&gt;'10:$10;20:$20;30:$30;40:$40;50:$50', \"multiple\" =&gt; true);\n\n// In case you want to use different delimiter (:) and separator (;), you can override\n$col[\"editoptions\"][\"delimiter\"] = \":\";\n$col[\"editoptions\"][\"separator\"] = \";\";\n</code></pre>"},{"location":"column-input-types.html#render-as-database-lookup-dropdown","title":"Render as database lookup (dropdown)","text":"<p>Property <code>editoptions</code> indexes are: foreign key table, foreign key id, label to show in dropdown</p> <pre><code>$col[\"edittype\"] = \"lookup\";\n$col[\"editoptions\"] = array(\"table\"=&gt;\"employees\", \"id\"=&gt;\"employee_id\", \"label\"=&gt;\"concat(first_name,' ',last_name)\");\n</code></pre> <p>Above will create a query like: select employee_id as k, concat(firstname,' ',last_name) as v from employees. You can also provide your own query for dropdown by:</p> <pre><code>$col[\"editoptions\"][\"sql\"] = \"select employee_id as k, concat(firstname,' ',last_name) as v from employees\";\n</code></pre>"},{"location":"column-input-types.html#render-dropdown-as-a-colored-badge","title":"Render dropdown as a colored badge","text":"<pre><code>$col[\"formatter\"] = \"badge\";\n</code></pre> <p>To have a clickable badge, which will open another grid row in edit mode:</p> <pre><code>$col[\"formatter\"] = \"badge\";\n$col[\"badgeoptions\"][\"editurl\"] = '/dev/demos/editing/index.php?grid_id=list1&amp;col=client_id';\n</code></pre> <p>where index.php in url is the grid with client_id as primary key.</p> <p></p>"},{"location":"column-input-types.html#rendering-a-colored-row-bar","title":"Rendering a colored row bar","text":"<p>This will show a rowbar before the text value of the column.</p> <pre><code>$col[\"formatter\"] = \"rowbar\";\n</code></pre> <p></p>"},{"location":"column-input-types.html#render-as-date-datetime-picker","title":"Render as Date &amp; Datetime Picker","text":"<p>Date formatter will make this column as date input (and will show date picker control) on add or edit operations.</p> <pre><code>$col[\"formatter\"] = \"date\";\n$col[\"formatoptions\"] = array(\"srcformat\"=&gt;'Y-m-d',\"newformat\"=&gt;'d/m/Y');\n</code></pre> <p>Datetime formatter will make this column as date time input (and will show date time picker control) on add or edit operations.</p> <pre><code>$col[\"formatter\"] = \"datetime\";\n$col[\"formatoptions\"] = array(\"srcformat\"=&gt;'Y-m-d',\"newformat\"=&gt;'d/m/Y');\n</code></pre> <p>Complete date formatting shortcode can be found on this link: http://www.php.net/manual/en/function.date.php</p> <p>By default, datepicker does not perform 'contains' search. If you wish to enable, you need to set following with date column. This will disable datepicker.</p> <pre><code>// contains search\n$col[\"searchoptions\"][\"sopt\"] = array(\"cn\");\n</code></pre> <p>Format of contains search is yyyy-mm-dd, which can be changed using 'dbname' property and mysql format_date function.</p> <pre><code>// search date in format Jan 23, 2008\n$col[\"dbname\"] = \"date_format(invdate,'%b %d, %Y')\";\n</code></pre>"},{"location":"column-input-types.html#render-as-button","title":"Render as button","text":"<pre><code>$col[\"edittype\"] = \"button\";\n$col[\"editoptions\"] = array(\"value\"=&gt;'Click Me');\n</code></pre>"},{"location":"column-input-types.html#render-radio-buttons-as-edittype","title":"Render Radio buttons as edittype","text":"<p>Radio buttons can be shown by custom method.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Closing Rate\";\n$col[\"name\"] = \"closed\";\n$col[\"width\"] = \"30\";\n$col[\"editable\"] = true;\n$col[\"align\"] = \"center\";\n$col[\"editoptions\"][\"dataInit\"] = \"function(o){edit_as_radio(o);}\";\n$cols[] = $col;\n</code></pre> <p>... and in html section, we can define custom edit-type display</p> <pre><code>&lt;script&gt;\nfunction edit_as_radio(o)\n{\n    setTimeout(function(){\n        jQuery(o).hide();\n        jQuery(o).parent().append('&lt;input title=\"0\" type=\"radio\" name=\"rd_closed\" value=\"0\" onclick=\"jQuery(\\'#total\\').val(0);\"/&gt; 0 &lt;input title=\"5\" type=\"radio\" name=\"rd_closed\" value=\"5\" onclick=\"jQuery(\\'#total\\').val(5);\"/&gt; 5 &lt;input title=\"10\" type=\"radio\" name=\"rd_closed\" value=\"10\" onclick=\"jQuery(\\'#total\\').val(10);\"/&gt; 10');\n    },100);\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"column-input-types.html#multiple-checkboxes-as-edittype","title":"Multiple checkboxes as edittype","text":"<pre><code>$col = array();\n$col[\"title\"] = \"Closed\";\n$col[\"name\"] = \"closed\";\n$col[\"width\"] = \"50\";\n$col[\"editable\"] = true;\n$col[\"editoptions\"][\"dataInit\"] = \"function(o){edit_as_custom(o);}\";\n$cols[] = $col;\n</code></pre> <p>and in html, add display function that will update the selection in main field (hidden)</p> <pre><code>&lt;script&gt;\n    function edit_as_custom(o)\n    {\n        setTimeout(function(){\n            jQuery(o).parent().append('&lt;input type=\"checkbox\" name=\"rd_closed\" value=\"1\" onclick=\"set_checkbox_value();\"/&gt; Option 1 &lt;input type=\"checkbox\" name=\"rd_closed\" value=\"2\" onclick=\"set_checkbox_value();\"/&gt; Option 2 &lt;input type=\"checkbox\" name=\"rd_closed\" value=\"3\" onclick=\"set_checkbox_value();\"/&gt; Option 3');\n            jQuery(o).css('display','none');\n\n            // here you can also read #closed value (if set) and set in checkboxes using jquery for edit mode\n\n        },100);\n    }\n\n    function set_checkbox_value()\n    {\n        jQuery('#closed').val( jQuery('input[name=rd_closed]:checked').map(function(){return this.value;}).get() );\n    }\n&lt;/script&gt;\n</code></pre>"},{"location":"column-options.html","title":"Column Settings","text":""},{"location":"column-options.html#column-options","title":"Column Options","text":"<p>We can also customize each column properties. Following are the parameters, that can be passed to customize column definition on grid.</p>"},{"location":"column-options.html#caption-shown-on-grid","title":"Caption shown on grid","text":"<pre><code>$col[\"title\"] = \"Details\";\n</code></pre>"},{"location":"column-options.html#db-field-name-or-alias-in-sql-query-table","title":"DB Field name (or alias) in sql query / table","text":"<pre><code>$col[\"name\"] = \"view_more\";\n</code></pre>"},{"location":"column-options.html#db-field-name-tablefield","title":"DB Field Name (table.field)","text":"<p>In case of field name ambiguity b/w tables, set as table.fieldname</p> <pre><code>$col[\"dbname\"] = \"c.id\";\n</code></pre>"},{"location":"column-options.html#width-of-the-column","title":"Width of the Column","text":"<pre><code>$col[\"width\"] = \"20\";\n\n// to set exact pixel width\n$col[\"fixed\"] = true;\n$col[\"width\"] = \"20\";\n</code></pre>"},{"location":"column-options.html#editable-truefalse","title":"Editable (true,false)","text":"<pre><code>$col[\"editable\"] = false;\n</code></pre>"},{"location":"column-options.html#viewable-truefalse","title":"Viewable (true,false)","text":"<p>When the option is set to false the column does not appear in view Form</p> <pre><code>$col[\"viewable\"] = false;\n</code></pre>"},{"location":"column-options.html#frozen-truefalse","title":"Frozen (true,false)","text":"<p>When the option is set to true the column will be freezed while scrolling. Column must be first column of grid OR after another freezed column.</p> <pre><code>$col[\"frozen\"] = true;\n</code></pre> <p>The following limitations tell you when frozen columns can not be set-up:</p> <pre><code>- When TreeGrid is enabled\n- When SubGrid is enabled\n- When cellEdit is enabled\n- When inline edit is used - the frozen columns can not be editable.\n- When sortable columns are enabled - grid parameter sortable is set to true or is function\n- When scroll is set to true or 1\n- When Data grouping is enabled\n- When footer row (footerrow paremeter) is enabled\n</code></pre>"},{"location":"column-options.html#allow-null-truefalse","title":"Allow null (true,false)","text":"<p>If db fields allows null and we want to save (NULL) instead of \"\". Defaults to false</p> <pre><code>$col[\"isnull\"] = true;\n</code></pre> <p>If you wisht to display blank on the grid instead of null</p> <pre><code>$col[\"formatter\"] = \"function(cellval,options,rowdata){ return cellval === null ? '' : cellval; }\";\n</code></pre>"},{"location":"column-options.html#has-auto-increment-column-truefalse","title":"Has Auto-increment Column (true,false)","text":"<p>First field in columns is by-default skipped from INSERT query (assuming to be primary key and auto increment). If you wish to include it in INSERT sql (non auto increment) you can set:</p> <pre><code>$col[\"autoid\"] = false;\n</code></pre>"},{"location":"column-options.html#resizable-truefalse","title":"Resizable (true,false)","text":"<pre><code>$col[\"resizable\"] = true;\n</code></pre>"},{"location":"column-options.html#position-numeric","title":"Position (numeric)","text":"<p>With position property you can set column order sequence (in numbers) with your desired column. e.g. Following will create a new  virtual column on second position of grid. It starts from 0 however setting it 0 (first column) should only be done if the content uniquely  identify each row (e.g PK of table). Otherwise edit,delete options may behave unexpected.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Report\";\n$col[\"name\"] = \"reportcol\";\n$col[\"editable\"] = false;\n$col[\"position\"] = 2;\n$col[\"template\"] = \"&lt;a href='#'&gt;Report&lt;/a&gt;\";\n$cols[] = $col;\n\n$g-&gt;set_columns($cols,true);\n</code></pre> <p>Output: https://i.imgur.com/gaZlysb.png</p>"},{"location":"column-options.html#readonly-column","title":"Readonly Column","text":"<p>You can also set certain column as readonly on edit dialog, and editable on add dialog.</p> <pre><code>$col[\"editrules\"][\"readonly\"] = true;\n</code></pre> <p>To make column readonly in both add and edit dialog, use following:</p> <pre><code>// shows defaultValue only on add dialog and readonly\n$col[\"editoptions\"] = array(\"defaultValue\"=&gt;\"Test Value\",\"readonly\"=&gt;\"readonly\", \"style\"=&gt;\"border:0px; margin: 3px 0px;\");\n</code></pre> <p>If you need to make a column non-editable when it contain some specific data, you can also put that condition using <code>readonly-when</code>. Refer column-access.php.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Gender\";\n$col[\"name\"] = \"gender\";\n$col[\"editable\"] = true;\n$col[\"editrules\"] = array(\"required\"=&gt;true, \"readonly\"=&gt;true, \"readonly-when\"=&gt;array(\"==\",\"male\"));\n$cols[] = $col;\n</code></pre> <p>To make checkbox readonly when it's checked or unchecked, set readonly-when to \"checked\" OR \"unchecked\".</p> <pre><code>$col = array();\n$col[\"title\"] = \"Closed\";\n$col[\"name\"] = \"closed\";\n$col[\"width\"] = \"50\";\n$col[\"editable\"] = true;\n$col[\"formatter\"] = \"checkbox\";\n$col[\"edittype\"] = \"checkbox\";\n$col[\"editoptions\"] = array(\"value\"=&gt;\"1:0\");\n$col[\"editrules\"] = array(\"readonly\"=&gt;true, \"readonly-when\"=&gt;\"unchecked\");\n$cols[] = $col;\n</code></pre> <p>For advance readonly logic, use callback function</p> <pre><code>$col[\"editrules\"] = array(\"required\"=&gt;true, \"readonly\"=&gt;true, \"readonly-when\"=&gt;\"check_client\");\n\n// html side .. JS callback function\n\n&lt;script&gt;\n// readonly gender conditional function - when return true, field will be readonly\nfunction check_client(formid)\n{\n    client_id = jQuery(\"input[name=client_id]:last, select[name=client_id]:last\",formid).val();\n    client_id = parseInt(client_id);\n\n    if (jQuery.inArray(client_id,[3,6,7,8,9]) != -1)\n        return true;\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"column-options.html#column-form-option","title":"Column Form Option","text":"<p>This option is valid only in form editing. The purpose of these options is to reorder the elements in the form and to add some information before and after the editing element.</p> <p><code>elmprefix</code> if set, a text or html content appears before the input element <code>elmsuffix</code> string  if set, a text or html content appears after the input element <code>label</code> string  if set, this replace the name from colNames array that appears as label in the form. <code>rowpos</code> determines the row position of the element (again with the text-label) in the form; the count begins from 1 <code>colpos</code> determines the column position of the element (again with thelabel) in the form beginning from 1</p> <p>If you plan to use this object in colModel with rowpos and colpos properties it is recommended that all editing fields use these properties.</p> <pre><code>$col[\"formoptions\"] = array(\"elmprefix\"=&gt;'(*)', \"rowpos\"=&gt;\"1\", \"colpos\"=&gt;\"2\");\n</code></pre> <p>To mark a field as required, you can use</p> <pre><code>$col[\"formoptions\"] = array(\"elmsuffix\"=&gt;'&lt;font color=red&gt; *&lt;/font&gt;');\n</code></pre>"},{"location":"column-options.html#column-formatters","title":"Column Formatters","text":"<p>To display select box (dropdown) label instead of value,</p> <pre><code>$col[\"formatter\"] = \"select\";\n</code></pre> <p>You can also set format options for numeric and currency data.</p> <pre><code>$col[\"formatter\"] = \"number\";\n$col[\"formatoptions\"] = array(\"thousandsSeparator\" =&gt; \",\",\n                                \"decimalSeparator\" =&gt; \".\",\n                                \"decimalPlaces\" =&gt; 2);\n\n$col[\"formatter\"] = \"currency\";\n$col[\"formatoptions\"] = array(\"prefix\" =&gt; \"$\",\n                                \"suffix\" =&gt; '',\n                                \"thousandsSeparator\" =&gt; \",\",\n                                \"decimalSeparator\" =&gt; \".\",\n                                \"decimalPlaces\" =&gt; 2);\n</code></pre> <p>Render as image,</p> <pre><code>$col[\"formatter\"] = \"image\";\n$col[\"formatoptions\"] = array(\"src\"=&gt;'http://test.com/image.jpg');\n</code></pre> <p>For custom formatter, e.g. image display</p> <pre><code>$col[\"formatter\"] = \"function(cellval,options,rowdata){ return '&lt;img src=\\\"'+cellval+'\\\" /&gt;'; }\";\n$col[\"unformat\"] = \"function(cellval,options,cell){ return $('img', cell).attr('src'); }\";\n</code></pre> <p>For custom formatter of percentage display</p> <pre><code>$col[\"formatter\"] = \"function(cellval,options,rowdata){ return Number(parseFloat(cellval)*100).toFixed(2)+'%'; }\";\n$col[\"unformat\"] = \"function(cellval,options,cell){ return cellval.replace('%','')/100; }\";\n</code></pre> <p>For custom formatter of fix height row (having html  content)</p> <pre><code>$col[\"formatter\"] = \"function(cellval,options,rowdata){ return '&lt;div style=\\\"height:25px; overflow:hidden;\\\"&gt;'+cellval+'&lt;/div&gt;'; }\";\n$col[\"unformat\"] = \"function(cellval,options,cell){ return jQuery(cell).children('div').html(); }\";\n</code></pre> <p>For raw link formatter</p> <pre><code>$col[\"formatter\"] = \"function(cellval,options,rowdata){ return '&lt;a target=\\\"_blank\\\" href=\\\"http://'+cellval+'\\\"&gt;'+cellval+'&lt;/a&gt;'; }\";\n$col[\"unformat\"] = \"function(cellval,options,cell){ return $('a', cell).attr('href').replace('http://',''); }\";\n</code></pre> <p>In unformatter, if you want to use row data you can use getRowData, e.g:</p> <pre><code>// here list1 is your grid id &amp; total_weight is row column to use\n$col[\"unformat\"] = \"function(cellval, options, cell) {\n                        var rowdata = $('#list1').getRowData(options.rowId);\n                        return cellval.replace('%','')*rowdata['total_weight']/100;\n                    }\";\n</code></pre>"},{"location":"column-options.html#text-alignment","title":"Text alignment","text":"<p>Possible values are left, right or center</p> <pre><code>$col[\"align\"] = \"center\";\n</code></pre>"},{"location":"column-options.html#searchable-truefalse","title":"Searchable (true,false)","text":"<p>Is searching allowed on this field. Possible values are true or false.</p> <pre><code>$col[\"search\"] = false;\n</code></pre>"},{"location":"column-options.html#dropdown-in-filter-row","title":"Dropdown in Filter Row","text":"<p>We need to set <code>stype</code> and <code>searchoptions</code> to enable dropdown search in autofilter.</p> <pre><code>// Fetch data from database, with alias k for key, v for value\n$str = $g-&gt;get_dropdown_values(\"select distinct client_id as k, name as v from clients\");\n\n$col[\"stype\"] = \"select\";\n$col[\"searchoptions\"] = array(\"value\" =&gt; $str, \"separator\" =&gt; \":\", \"delimiter\" =&gt; \";\");\n</code></pre>"},{"location":"column-options.html#column-search-operators","title":"Column Search Operators","text":"<p>Optionally set limited search operators (e.g. bw = begins with, 'eq','ne','lt','le','gt','ge','bw','bn','in','ni','ew','en','cn','nc')</p> <p>This will limit search operators for this columns to begins-with, equal, cotains</p> <pre><code>$col[\"searchoptions\"][\"sopt\"] = array(\"bw\",\"eq\",\"cn\");\n</code></pre> <p>If you pass single operator, only that will be used in autofilter and override default contains search</p> <pre><code>$col[\"searchoptions\"][\"sopt\"] = array(\"eq\");\n</code></pre>"},{"location":"column-options.html#sortable-truefalse","title":"Sortable (true,false)","text":"<p>Sorting column can be enabled or disabled by setting true or false.</p> <pre><code>$col[\"sortable\"] = false;\n</code></pre>"},{"location":"column-options.html#sort-type","title":"Sort type","text":"<p>Defines the type of sort for column. Only used when grid loads with array. Possible values:</p> <ul> <li>int/integer - for sorting integer</li> <li>float/number/currency - for sorting decimal numbers</li> <li>date - for sorting date</li> <li> <p>text - for text sorting</p> <p>$col[\"sorttype\"] = int;</p> </li> </ul>"},{"location":"column-options.html#column-content-as-hyperlink","title":"Column Content as Hyperlink","text":"<p>We can use exiting db-field value of that row in URL pattern. For e.g. if we have a grid column named 'id', we can insert it's value in URL using {id}. Here we set, http://domain.com?param={id} given that, there is a column with $col[\"name\"] = \"id\" exist.</p> <pre><code>$col[\"template\"] = \"&lt;a target='_blank' href='http://google.com/?q={id}'&gt;{id}&lt;/a&gt;\";\n</code></pre> <p>There is a limitation that you cannot make first column as hyperlink, as it is usually PK and used in INSERT/UPDATE. Alternate solution could be to select same field 2 times in SQL, and make first as hidden and second as hyperlink.</p>"},{"location":"column-options.html#static-content","title":"Static Content","text":"<p>If the column is static data (non database driven), we can set it with default param. We can set custom HTML too, for e.g. <code>&lt;img&gt;</code> or <code>&lt;div&gt;</code> etc.</p> <pre><code>$col[\"template\"] = \"Custom Text\";\n</code></pre>"},{"location":"column-options.html#dynamic-content","title":"Dynamic Content","text":"<p>We can also use <code>{field}</code> replacement in <code>default</code> parameter. Here is an example for custom column to show bar graph. Where <code>bar</code> is a column alias from SQL statement.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Performance\";\n$col[\"name\"] = \"bar\";\n$col[\"width\"] = \"40\";\n$col[\"align\"] = \"left\";\n$col[\"search\"] = false;\n$col[\"sortable\"] = false;\n$col[\"template\"] = \"&lt;div style='width:{bar}px; background-color:navy; height:14px'&gt;&lt;/div&gt;\";\n$cols[] = $col;\n</code></pre> <p>In same way, we can embed dynamic images and other media (flv or swf) in grid.</p>"},{"location":"column-options.html#conditional-content","title":"Conditional Content","text":"<p>We can also provide certain condition, based on which either row data will be displayed. NOTE: Use single quote for condition, and $row will have all columns data, to use in condition.</p> <pre><code>$col[\"condition\"] = array('$row[\"total\"] &lt; 100', $data1, $data2);\n</code></pre> <p>Now if the condition is met, <code>$data1</code> will be displayed otherwise <code>$data2</code>. You can also <code>{field}</code> replacement in <code>$data1</code> &amp; <code>$data2</code>. Refer example below.</p> <pre><code># no new line in this html, only space. otherwise it may break ui of grid\n$buttons_buy = \"&lt;a target='_blank' href='http://www.amazon.com?id={id}'&gt;Buy&lt;/a&gt;\";\n$buttons_try = \"&lt;a target='_blank' href='http://www.google.com?id={id}'&gt;Try&lt;/a&gt;\";\n$col[\"condition\"] = array('$row[\"total\"] &gt; 10', $buttons_buy, $buttons_try);\n</code></pre> <p>For extended conditional data, you can also have callback function, that will allow you to display based on row data. For e.g.</p> <pre><code>$col[\"on_data_display\"] = array(\"display_keyword\",\"\");\n\nfunction display_keyword($data)\n{\n    $kw = $data[\"keyword_name\"];\n    $numKeywords = count(explode(\"\\n\",$pass));\n    if ($numKeywords &gt; 3)\n           return $numKeywords.\" Keywords\";\n    else\n    {\n           $pass = str_replace(\"+\",\" \",$pass);\n           return $pass;\n    }\n}\n</code></pre>"},{"location":"column-options.html#hiding-column","title":"Hiding Column","text":"<p>At instance, we don't want to show column in grid (like primary key), and it is equally needed for background operations like update or delete. <code>hidden</code> property can work here.</p> <pre><code>// don't show this column in list, but in edit/add mode\n$col[\"hidden\"] = true;\n</code></pre> <p>If <code>hidedlg</code> set to true this column will not appear in the modal dialog (colchooser / showhidecolumn) where users can choose which columns to show or hide.</p> <pre><code>$col[\"hidedlg\"] = true;\n</code></pre> <p>Another scenario is we want to hide it on grid list, and display it on Add or Edit forms.</p> <pre><code>$col[\"editrules\"] = array(\"edithidden\"=&gt;true);\n</code></pre> <p>If you want to enable searching on this hidden column, set</p> <pre><code>$col[\"searchoptions\"] = array(\"searchhidden\" =&gt; true);\n</code></pre> <p>You can also customize in one line, on which dialog/section this column will be displayed. Possible options are true or false. This may override the hidden and edithidden settings. See column-access.php</p> <pre><code>$col[\"show\"] = array(\"list\"=&gt;true, \"add\"=&gt;true, \"edit\"=&gt;true, \"view\"=&gt;true, \"bulkedit\"=&gt;true);\n</code></pre>"},{"location":"column-options.html#row-action-column","title":"Row Action Column","text":"<p>When we enable inline edit/delete option, An additional column <code>Action</code> is appended as last column of grid. We can also specify, by defining a column with name <code>$col[\"name\"] = \"act\";</code>. After that all changes will be applied on that column.</p> <p>Customization of Action column width and other properties:</p> <pre><code>$col = array();\n$col[\"title\"] = \"Action\";\n$col[\"name\"] = \"act\";\n$col[\"width\"] = \"50\";\n$cols[] = $col;\n</code></pre>"},{"location":"column-settings-faqs.html","title":"Column Settings FAQs","text":""},{"location":"column-settings-faqs.html#column-settings-faqs","title":"Column Settings FAQs","text":""},{"location":"column-settings-faqs.html#q-how-to-integrate-autocomplete-function","title":"Q) How to integrate autocomplete function?","text":"<p>Step1: Select ID and Data both in select command. (e.g. client_id, clients.name)</p> <pre><code>$g-&gt;select_command = \"SELECT id, invdate, invheader.client_id, clients.name as cid, amount, note FROM invheader\nINNER JOIN clients on clients.client_id = invheader.client_id\n\";\n</code></pre> <p>Step2: Place ID field in grid, (optionally hidden)</p> <pre><code>// field that will be updated by autocomplete\n$col = array();\n$col[\"title\"] = \"client_id\";\n$col[\"name\"] = \"client_id\";\n$col[\"width\"] = \"10\";\n$col[\"editable\"] = true;\n$col[\"hidden\"] = true;\n$cols[] = $col;\n</code></pre> <p>Step3: Place DATA field in grid, with autocomplete formatter.</p> <pre><code>// normal textbox, with autocomplete enabled\n$col = array();\n$col[\"title\"] = \"Client\";\n$col[\"name\"] = \"cid\";\n$col[\"dbname\"] = \"clients.name\"; // this is required as we need to search in name field, not id\n$col[\"width\"] = \"100\";\n$col[\"align\"] = \"left\";\n$col[\"search\"] = true;\n$col[\"editable\"] = true;\n$col[\"formatter\"] = \"autocomplete\"; // autocomplete\n$col[\"formatoptions\"] = array(  \"sql\"=&gt;\"SELECT client_id, name FROM clients\",\n                                \"search_on\"=&gt;\"name\",\n                                \"update_field\" =&gt; \"client_id\");\n</code></pre> <p>It will search in passed SQL for autocomplete, and selection ID will be set in field client_id.</p>"},{"location":"column-settings-faqs.html#q-how-can-i-get-unqiue-values-in-autocomplete","title":"Q) How can i get unqiue values in autocomplete?","text":"<p>You can change the input SQL to use GROUP BY clause. For example, to get unique 'release', you can use following query.</p> <pre><code>$col[\"formatoptions\"] = array(\n                                \"sql\"=&gt;\"SELECT * FROM (SELECT id as k, release as v FROM tbl_releases GROUP BY release) o\",\n                                \"search_on\"=&gt;\"v\",\n                                \"update_field\" =&gt; \"id\");\n</code></pre>"},{"location":"column-settings-faqs.html#q-how-can-i-show-lookup-dropdown-from-other-table-ie-linked-with-fk-data","title":"Q) How can i show lookup dropdown from other table (i.e. linked with FK data)","text":"<p>First step is to select the table which you want to use in grid, which will include table join.</p> <pre><code>$g-&gt;select_command = \"SELECT id, invdate, invheader.client_id, amount, note FROM invheader\n                        INNER JOIN clients on clients.client_id = invheader.client_id\n                        \";\n</code></pre> <p>After that, you need to define column like this.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Client\";\n$col[\"name\"] = \"client_id\"; // same as aliased name (fk)\n$col[\"dbname\"] = \"clients.name\"; // this is required as we need to search in name field, not id\n...\n$col[\"edittype\"] = \"select\"; // render as select\n\n# fetch data from database, with alias k for key, v for value\n$str = $g-&gt;get_dropdown_values(\"select distinct client_id as k, name as v from clients\");\n$col[\"editoptions\"] = array(\"value\"=&gt;$str);\n\n$col[\"formatter\"] = \"select\"; // show label in grid, instead of value\n\n$cols[] = $col;\n</code></pre> <p>Refer dropdown.php for working demo.</p>"},{"location":"column-settings-faqs.html#q-how-can-i-set-default-value-to-some-field","title":"Q) How can i set default value to some field?","text":"<p>You can set it by following code.</p> <pre><code>// This will set textbox with 10 as default value.\n$col[\"editoptions\"] = array(\"size\"=&gt;20, \"defaultValue\"=&gt;'10');\n\n// This will set current date as default value.\n$col[\"editoptions\"] = array(\"size\"=&gt;20, \"defaultValue\"=&gt; date(\"Y-m-d H:i:s\") );\n</code></pre> <p>Make sure that column has editable =&gt; true, You can make hidden =&gt; true if you dont want to show it (like in case of session id data)</p>"},{"location":"column-settings-faqs.html#q-how-to-populate-other-column-based-on-previous-columns","title":"Q) How to populate other column, based on previous columns?","text":"<p>Solution 1: In following example, text3 will be calculated based on text1 &amp; text2. You can use onblur event and do your own JS code to set value. You can also inspect the ID of elements of form using firebug.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Height\";\n$col[\"name\"] = \"height\";\n$col[\"editable\"] = true;\n$col[\"editoptions\"] = array(\"onblur\" =&gt; \"update_field()\");\n$cols[] = $col;\n\n$col = array();\n$col[\"title\"] = \"Width\";\n$col[\"name\"] = \"width\";\n$col[\"editable\"] = true;\n$col[\"editoptions\"] = array(\"onblur\" =&gt; \"update_field()\");\n$cols[] = $col;\n\n$col = array();\n$col[\"title\"] = \"Area\";\n$col[\"name\"] = \"area\";\n$col[\"editable\"] = true;\n$cols[] = $col;\n</code></pre> <p>and in html, put following js function to calculate field.</p> <pre><code>&lt;script&gt;\nfunction update_field()\n{\n    // for inline (any tag input, textarea or select)\n    jQuery('[name=\"area\"].editable').val(\n                        parseFloat(jQuery('[name=\"width\"].editable').val()) *\n                        parseFloat(jQuery('[name=\"height\"].editable').val())\n                        );\n\n    // for dialog (any tag input, textarea or select)\n    jQuery('[name=\"area\"].FormElement').val(\n                        parseFloat(jQuery('[name=\"width\"].FormElement').val()) *\n                        parseFloat(jQuery('[name=\"height\"].FormElement').val())\n                        );\n}\n&lt;/script&gt;\n</code></pre> <p>You can inspect the field id.using firebug and use jquery functions to disable / enable desired field. To know jquery selector:</p> <pre><code>http://easycaptures.com/fs/uploaded/1017/9892108434.png\nhttp://easycaptures.com/fs/uploaded/1017/9617668813.png\n</code></pre> <p>Solution 2: This is also doable on server side with callback functions: e.g. We want to have sum of  field <code>a</code> and <code>b</code> in field <code>c</code> which may or may not be shown on form.</p> <pre><code>$e[\"on_update\"] = array(\"update_field\", null, true);\n$e[\"on_insert\"] = array(\"update_field\", null, true);\n$g-&gt;set_events($e);\n\nfunction update_field($data)\n{\n    $data[\"params\"][\"c\"] = $data[\"params\"][\"a\"] + $data[\"params\"][\"b\"]\n}\n</code></pre> <p>Whatever value of <code>a</code> &amp; <code>b</code> are posted back they will be summed and used for column <code>c</code>  in sql query internally executed by library.</p>"},{"location":"column-settings-faqs.html#q-how-to-use-enter-intead-of-tab-in-moving-to-next-form-input","title":"Q) How to use ENTER intead of TAB in moving to next form input?","text":"<p>Following JS code will emulate ENTER as TAB. Put this script code before <code>echo $out</code>;</p> <pre><code>&lt;script&gt;\n    var opts = {\n        'loadComplete': function () {\n            $('body').on('keydown', 'input, select, textarea', function(e) {\n                var self = $(this)\n                  , form = self.parents('form:eq(0)')\n                  , focusable\n                  , next\n                  ;\n                if (e.keyCode == 13) {\n                    focusable = form.find('input,a,select,button,textarea').filter(':visible');\n                    next = focusable.eq(focusable.index(this)+1);\n                    if (next.length) {\n                        next.focus();\n                    } else {\n                        form.submit();\n                    }\n                    return false;\n                }\n            });\n        }\n    };\n&lt;/script&gt;\n...\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre>"},{"location":"column-settings-faqs.html#q-how-to-set-focus-of-some-other-field-while-adding-record","title":"Q) How to set focus of some other field while adding record?","text":"<p>This JS event enables you to set customization in add/edit forms just after they are displayed. For e.g.</p> <pre><code>$grid[\"add_options\"][\"afterShowForm\"] = 'function(formid) { jQuery(\"#date\").focus(); }';\n$g-&gt;set_options($grid);\n</code></pre>"},{"location":"column-settings-faqs.html#q-how-to-make-a-field-only-editable-on-add-dialog-otherwise-un-editable","title":"Q) How to make a field only editable on Add Dialog, otherwise un-editable?","text":"<p>We'll set the \"name\" column as editable-&gt;false by default. Then we'll enable it on add dialog using following grid settings.</p> <pre><code>$grid[\"add_options\"][\"beforeInitData\"] = \"function(formid) { $('#list1').jqGrid('setColProp','name',{editable:true}); }\";\n$grid[\"add_options\"][\"afterShowForm\"] = \"function(formid) { $('#list1').jqGrid('setColProp','name',{editable:false}); }\";\n...\n$g-&gt;set_options($grid);\n</code></pre> <p>Where \"list1\" is ID of grid passed in render() function, and \"name\" is the column to make editable on Add Dialog.</p>"},{"location":"column-settings-faqs.html#q-how-to-mask-a-field-for-example-like-this-nn-nnnn-nnnn-n-stands-for-number","title":"Q) How to mask a field, for example like this: (NN) NNNN-NNNN ? N stands for number.","text":"<p>You can pick input jquery id selectors, and link it using any lib.</p> <p>Library 1: For e.g. http://igorescobar.github.io/jQuery-Mask-Plugin/</p> <p>Step1: Add JS lib</p> <pre><code>&lt;script src=\"//cdnjs.cloudflare.com/ajax/libs/jquery.mask/0.9.0/jquery.mask.min.js\"&gt;&lt;/script&gt;\n</code></pre> <p>Step2: Set field integration, usually $col['name'] is ID of html element</p> <pre><code>$opt[\"add_options\"][\"afterShowForm\"] = 'function(formid) { jQuery(\"#amount\").mask(\"000.00\"); }';\n$opt[\"edit_options\"][\"afterShowForm\"] = 'function(formid) { jQuery(\"#amount\").mask(\"000.00\"); }';\n$g-&gt;set_options($opt);\n</code></pre> <p>For more options, refer: http://igorescobar.github.io/jQuery-Mask-Plugin/</p> <p>Library 2: For e.g. http://github.com/RobinHerbots/jquery.inputmask</p> <p>Step1: Add JS lib</p> <pre><code>&lt;!-- masked fields--&gt;\n&lt;script src=\"js/jquery.inputmask.js\"&gt;&lt;/script&gt;\n&lt;script src=\"js/jquery.inputmask.date.extensions.js\" &gt;&lt;/script&gt;\n&lt;script src=\"js/jquery.inputmask.numeric.extensions.js\"&gt;&lt;/script&gt;\n\n&lt;!-- OR use github link --&gt;\n&lt;script src=\"//rawgit.com/RobinHerbots/jquery.inputmask/3.x/dist/jquery.inputmask.bundle.js\"&gt;&lt;/script&gt;\n</code></pre> <p>Step2: Set field integration, usually $col['name'] is ID of html element</p> <pre><code>$grid[\"edit_options\"][\"afterShowForm\"] = 'function(list1) {\n    jQuery(\"#StartDate\").inputmask(\"mm/dd/yyyy\", {yearrange: { minyear: 2010, maxyear: 2020 }});\n    jQuery(\"#Worth\").inputmask(\"currency\", {prefix:\"$ \",groupSeparator:\",\",alias:\"numeric\",placeholder:\"0\",autoGroup:!0,digits:2,digitsOptional:!1,clearMaskOnLostFocus:!1});\n }';\n</code></pre> <p>For more options, refer: http://robinherbots.github.io/jquery.inputmask</p>"},{"location":"column-settings-faqs.html#q-how-to-change-column-title-at-runtime","title":"Q) How to change column title at runtime ?","text":"<p>Following JS code will change the column title in grid, where <code>list1</code> is grid id and 'name` is column name.</p> <pre><code>jQuery(\"#list1\").setLabel(\"name\",\"Client Name\");\n</code></pre> <p>You can also use HTML in column title. (for e.g. setting image as column title)</p>"},{"location":"column-settings-faqs.html#q-how-to-geonames-lib-for-city-country-code-autocomplete-lookup","title":"Q) How to GeoNames lib for City, Country, Code autocomplete lookup?","text":"<p>Simple include Geonames JS lib in html</p> <pre><code>&lt;script src=\"http://tompi.github.io/jeoquery/jeoquery.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>And use dataInit property for autocomplete lookup:</p> <pre><code>$col = array();\n$col[\"title\"] = \"City Name\";\n$col[\"name\"] = \"city\";\n$col[\"editable\"] = true;\n$col[\"width\"] = \"40\";\n$col[\"editoptions\"][\"dataInit\"] = \"function(o){  jQuery(o).jeoCityAutoComplete(); }\";\n$cols[] = $col;\n</code></pre>"},{"location":"column-settings-faqs.html#q-how-to-use-select2-comboxbox-like-function-with-grid-4-php","title":"Q) How to use 'select2' comboxbox like function with Grid 4 PHP?","text":"<p>1) Added 'dataInit' line with select column:</p> <pre><code>$col = array();\n$col[\"title\"] = \"Client\";\n$col[\"name\"] = \"client_id\";\n$col[\"editable\"] = true;\n$col[\"edittype\"] = \"select\";\n$col[\"editoptions\"][\"dataInit\"] = \"function(){ setTimeout(function(){ $('select[name=client_id]').select2({width:'80%', dropdownCssClass: 'ui-widget ui-jqdialog'}); },200); }\";\n...\n$cols[] = $col;\n</code></pre> <p>2) Added select2 JS/CSS files:</p> <pre><code>&lt;link href=\"//cdnjs.cloudflare.com/ajax/libs/select2/3.4.6/select2.css\" rel=\"stylesheet\"/&gt;\n&lt;script src=\"//cdnjs.cloudflare.com/ajax/libs/select2/3.4.6/select2.min.js\"&gt;&lt;/script&gt;\n</code></pre> <p>You can further add 'select2' options by referring it's documentation, and placing param with in dataInit code: .select2({ ... });</p>"},{"location":"column-settings-faqs.html#q-how-to-use-qtip2-with-grid-4-php","title":"Q) How to use 'qtip2' with Grid 4 PHP?","text":"<p>1) Include JS/CSS</p> <pre><code>&lt;link rel=\"stylesheet\" href=\"//cdn.jsdelivr.net/qtip2/2.2.1/jquery.qtip.min.css\"&gt;\n&lt;script src=\"//cdn.jsdelivr.net/qtip2/2.2.1/jquery.qtip.min.js\"&gt;&lt;/script&gt;\n</code></pre> <p>2) Connect onload event</p> <pre><code>$grid[\"loadComplete\"] = \"function(){ connect_qtip(); }\";\n$g-&gt;set_options($grid);\n</code></pre> <p>3) Connect qtip2 e.g. for all title attributes</p> <pre><code>&lt;style&gt;\n.qtip-content{\n    font-family: tahoma, helvetica, 'sans-serif';\n}\n&lt;/style&gt;\n\n&lt;script&gt;\nfunction connect_qtip()\n{\n    jQuery('[title]').qtip({\n                                position: {\n                                my: 'bottom left',  // Position my top left...\n                                at: 'top left' // at the bottom right of...\n                                }\n                        });\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"column-settings-faqs.html#q-how-to-fill-dropdown-with-different-values-wrt-record","title":"Q) How to fill dropdown with different values w.r.t. record?","text":"<p>You can do it using dataInit event handler.</p> <pre><code>$col[\"editoptions\"][\"dataInit\"] = \"function(){ setTimeout(function(){ load_dd(); },200); }\";\n</code></pre> <p>Based on some input value (e.g. invdate=2015-02-18) you can change options of dropdown.</p> <pre><code>&lt;script&gt;\nfunction load_dd()\n{\n    var grid = $('#list1');\n    var selectValues;\n\n    if ($('input[name=invdate]').val() == '2015-02-18')\n        selectValues = { \"1\": \"test 1\", \"2\": \"test 2\" };\n    else\n        selectValues = { \"3\": \"test 3\", \"4\": \"test 4\" };\n\n    $('select[name=client_id]').html('');\n\n    $.each(selectValues, function(key, value) {\n         $('select[name=client_id]')\n              .append($('&lt;option&gt;', { value : key })\n              .text(value));\n    });\n}\n&lt;/script&gt;\n</code></pre> <p>Sample code: http://hastebin.com/eqedajegov.php</p>"},{"location":"column-settings-faqs.html#q-how-to-customize-the-toolbar-features-of-html-editor-ckeditor","title":"Q) How to customize the toolbar features of Html editor (CKEditor)?","text":"<p>You can customize buttons in config.js of CK editor. (\\lib\\js\\ckeditor\\config.js) CK editor docs: http://docs.ckeditor.com/#!/guide/dev_toolbar</p> <p>Sample config.js contents:</p> <pre><code>CKEDITOR.editorConfig = function( config ) {\n    // Define changes to default configuration here.\n    // For complete reference see:\n    // http://docs.ckeditor.com/#!/api/CKEDITOR.config\n\n    // The toolbar groups arrangement, optimized for two toolbar rows.\n    config.toolbarGroups = [\n        { name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },\n        { name: 'editing',     groups: [ 'find', 'selection' ] },\n        { name: 'links' },\n        { name: 'insert' },\n        { name: 'forms' },\n        { name: 'tools' },\n        { name: 'document',    groups: [ 'document', 'doctools' ] },\n        { name: 'others' },\n        '/',\n        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },\n        { name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },\n        { name: 'styles' },\n        { name: 'colors' },\n    ];\n\n    // Remove some buttons provided by the standard plugins, which are\n    // not needed in the Standard(s) toolbar.\n    config.removeButtons = 'Underline,Subscript,Superscript';\n\n    // Set the most common block elements.\n    config.format_tags = 'p;h1;h2;h3;pre';\n\n    // Simplify the dialog windows.\n    config.removeDialogTabs = 'image:advanced;link:advanced';\n\n    config.extraPlugins='onchange';\n    config.skin = 'bootstrapck';\n    // config.width = '300px';\n    config.minimumChangeMilliseconds = 100; // 100 milliseconds (default value)\n};\n</code></pre>"},{"location":"column-settings-faqs.html#q-frozen-column-does-not-work-what-are-the-limitations","title":"Q) Frozen column does not work. What are the limitations?","text":"<p>The following limitations tell you when frozen columns can not be set-up</p> <ul> <li>When SubGrid is enabled</li> <li>When cellEdit is enabled</li> <li>When inline edit is used - the frozen columns can not be edit.</li> <li>When sortable columns are enabled - grid parameter sortable is set to true or is function</li> <li>When scroll is set to true or 1</li> <li>When Data grouping is enabled</li> <li>When footer row (footerrow paremeter) is enabled</li> </ul>"},{"location":"column-settings-faqs.html#q-how-to-change-language-of-datepicker-control-localization","title":"Q) How to change language of datepicker control (localization)?","text":"<p>Add following code in html head, after downloading and setting lang file path. e.g.</p> <pre><code>&lt;script src=\"//cdn.jsdelivr.net/gh/jquery/jquery-ui@master/ui/i18n/datepicker-ar.js\"&gt;&lt;/script&gt;\n&lt;script&gt;\n$.datepicker.setDefaults( $.datepicker.regional[ \"ar\" ] );\n&lt;/script&gt;\n</code></pre> <p>All language files can be downloaded from: https://github.com/jquery/jquery-ui/tree/master/ui/i18n</p>"},{"location":"column-settings-faqs.html#q-how-to-set-minimum-date-of-datepicker-control","title":"Q) How to set minimum date of datepicker control?","text":"<p>You can set opts array (in formatoptions) which can have these options: http://api.jqueryui.com/datepicker/</p> <pre><code>$col[\"formatoptions\"] = array(\"srcformat\"=&gt;'Y-m-d',\"newformat\"=&gt;'d.m.Y',\n                                \"opts\" =&gt; array(\"changeYear\" =&gt; true, \"dateFormat\"=&gt;'yy-mm-dd', \"minDate\"=&gt;\"15-07-08\"));\n</code></pre>"},{"location":"conditional-formatting.html","title":"Conditional Formatting","text":""},{"location":"conditional-formatting.html#conditional-formatting","title":"Conditional Formatting","text":"<p>With conditional formatting, you can specify the CSS of rows or columns based on data in it. When specifying class name you must declare the css class in your document before usage. (refer example: conditional-format.php)</p> <pre><code>// conditional css formatting of rows\n\n$f = array();\n$f[\"column\"] = \"name\"; // exact column name, as defined above in set_columns or sql field name\n$f[\"op\"] = \"cn\"; // cn - contains, eq - equals\n$f[\"value\"] = \"Ana\";\n$f[\"class\"] = \"focus-row\"; // css class name\n$f_conditions[] = $f;\n\n$f = array();\n$f[\"column\"] = \"invdate\";\n$f[\"op\"] = \"eq\";\n$f[\"value\"] = \"2007-10-04\";\n$f[\"class\"] = \"focus-row-red\";\n$f_conditions[] = $f;\n\n// apply style on target column, if defined cellclass OR cellcss\n$f = array();\n$f[\"column\"] = \"id\";\n$f[\"op\"] = \"=\";\n$f[\"value\"] = \"7\";\n$f[\"cellclass\"] = \"focus-cell\";\n$f[\"target\"] = \"name\";\n$f_conditions[] = $f;\n</code></pre> <p>If nothing set in 'op' and 'value', it will set column formatting for all cell</p> <pre><code>$f = array();\n$f[\"column\"] = \"invdate\";\n$f[\"css\"] = \"'background-color':'#FBEC88', 'color':'black'\";\n$f_conditions[] = $f;\n</code></pre> <p>Finally, you need to call <code>set_conditional_css</code> of grid object to enable formatting.</p> <pre><code>$g-&gt;set_conditional_css($f_conditions);\n</code></pre> <p>Refer demos/appearance/conditional-format.php for reference.</p>"},{"location":"conditional-formatting.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/conditional-format.php</code></li> </ul>"},{"location":"connecting-with-oracle.html","title":"Connecting with Oracle","text":""},{"location":"connecting-with-oracle.html#connecting-with-oracle","title":"Connecting with Oracle","text":"<p>Following code snippet connect PHP Grid with Oracle.</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"oci8\"; // mysql,oci8(for oracle),mssql,postgres,sybase\n$db_conf[\"server\"] = \"127.0.0.1:1521\";\n$db_conf[\"user\"] = \"system\";\n$db_conf[\"password\"] = \"asd\";\n$db_conf[\"database\"] = \"xe\";\n\ninclude(\"../../lib/inc/jqgrid_dist.php\");\n$g = new jqgrid($db_conf);\n</code></pre>"},{"location":"connecting-with-oracle.html#resources","title":"Resources","text":"<ul> <li>Oracle Sample Code</li> <li>You can check this demo in archive <code>demos/loading/oracle-master-detail.php</code></li> </ul>"},{"location":"connecting-with-postgres.html","title":"Connecting with Postgres","text":""},{"location":"connecting-with-postgres.html#connecting-with-postgres","title":"Connecting with Postgres","text":"<p>Following code snippet connect PHP Grid with Postgres.</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"postgres\"; // mysql,oci8(for oracle),mssql,postgres,sybase\n$db_conf[\"server\"] = \"localhost\";\n$db_conf[\"user\"] = \"postgres\";\n$db_conf[\"password\"] = \"abcd\";\n$db_conf[\"database\"] = \"testdb\"\n\n$g = new jqgrid($db_conf);\n</code></pre>"},{"location":"connecting-with-postgres.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>You can check this demo in archive <code>demos/loading/db-layer-pgsql.php</code></li> </ul>"},{"location":"connecting-with-sql-server.html","title":"Connecting with SQL Server","text":""},{"location":"connecting-with-sql-server.html#connecting-with-sql-server","title":"Connecting with SQL Server","text":"<p>Following code snippet connect PHP Grid Framework to SQL Server.</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"mssqlnative\";\n$db_conf[\"server\"] = \"(local)\\sqlexpress\";\n$db_conf[\"user\"] = null;\n$db_conf[\"password\"] = null;\n$db_conf[\"database\"] = \"master\";\n\n$g = new jqgrid($db_conf);\n\n...\n\n$g-&gt;table = \"[msdb].[dbo].[syscategories]\";\n</code></pre>"},{"location":"connecting-with-sql-server.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>You can check this demo in archive <code>demos/loading/db-layer-sqlsvr.php</code></li> </ul> <p>Connecting Azure database:</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"mssqlnative\";\n$db_conf[\"server\"] = \"phpgrid.database.windows.net\"; // ip:port\n$db_conf[\"user\"] = \"admin_phpgrid\";\n$db_conf[\"password\"] = \"xxxxx\";\n$db_conf[\"database\"] = \"griddemo\";\n\ninclude(\"../../lib/inc/jqgrid_dist.php\");\n$g = new jqgrid($db_conf);\n</code></pre> <p>Using PDO for SQL Server Azure:</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"pdo\";\n$db_conf[\"server\"] = \"sqlsrv:Server=phpgrid.database.windows.net\";\n$db_conf[\"user\"] = \"admin_phpgrid\"; // username\n$db_conf[\"password\"] = \"xxxxx\"; // password\n$db_conf[\"database\"] = \"griddemo\"; // database\n\ninclude(\"../../lib/inc/jqgrid_dist.php\");\n$g = new jqgrid($db_conf);\n</code></pre>"},{"location":"connecting-with-sql-server.html#resources_1","title":"Resources","text":"<ul> <li>Sample Code</li> <li>You can check this demo in archive <code>demos/loading/db-layer-sqlsvr-azure.php</code></li> </ul>"},{"location":"creating-first-grid.html","title":"Creating First Grid","text":""},{"location":"creating-first-grid.html#creating-first-grid","title":"Creating First Grid","text":"<p>Step1: Add PHP Grid configuration code</p> <pre><code>&lt;?php\ninclude_once(\"../../config.php\");\n\n// include and create object\ninclude(PHPGRID_LIBPATH.\"inc/jqgrid_dist.php\");\n\n$db_conf = array(\n                    \"type\"      =&gt; PHPGRID_DBTYPE,\n                    \"server\"    =&gt; PHPGRID_DBHOST,\n                    \"user\"      =&gt; PHPGRID_DBUSER,\n                    \"password\"  =&gt; PHPGRID_DBPASS,\n                    \"database\"  =&gt; PHPGRID_DBNAME\n                );\n\n$g = new jqgrid($db_conf);\n\n// set few params\n$opt[\"caption\"] = \"Sample Grid\";\n$g-&gt;set_options($opt);\n\n// set database table for CRUD operations\n$g-&gt;table = \"clients\";\n\n// render grid and get html/js output\n$out = $g-&gt;render(\"list1\");\n?&gt;\n</code></pre> <p>Step2: Include JS and CSS files in your html page</p> <pre><code>&lt;!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\"&gt;\n&lt;html&gt;\n&lt;head&gt;\n\n    &lt;!-- these css and js files are required by php grid --&gt;\n    &lt;link rel=\"stylesheet\" href=\"../../lib/js/themes/redmond/jquery-ui.custom.css\"&gt;&lt;/link&gt;\n    &lt;link rel=\"stylesheet\" href=\"../../lib/js/jqgrid/css/ui.jqgrid.css\"&gt;&lt;/link&gt;\n    &lt;script src=\"../../lib/js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n    &lt;script src=\"../../lib/js/jqgrid/js/i18n/grid.locale-en.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n    &lt;script src=\"../../lib/js/jqgrid/js/jquery.jqGrid.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n    &lt;script src=\"../../lib/js/themes/jquery-ui.custom.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n    &lt;!-- these css and js files are required by php grid --&gt;\n\n&lt;/head&gt;\n</code></pre> <p>Step3: Print the <code>$out</code> variable where you wish to display grid.</p> <pre><code>&lt;body&gt;\n    &lt;div&gt;\n\n    &lt;!-- display grid here --&gt;\n    &lt;?php echo $out?&gt;\n    &lt;!-- display grid here --&gt;\n\n    &lt;/div&gt;\n&lt;/body&gt;\n&lt;/html&gt;\n</code></pre>"},{"location":"creating-first-grid.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/editing/index.php</code></li> </ul>"},{"location":"creating-first-grid.html#explanation","title":"Explanation","text":"<ul> <li>The PHP Part configured the grid and rendered the output to $out variable.</li> <li>In HTML Part, we displayed the generated grid code <code>$out</code> along with few external css/js files. It's upto you to place external css and js files at appropriate locations.</li> <li><code>-&gt;set_options()</code> function is most of the customization, we'll be covering later.</li> <li><code>-&gt;table</code> is required, to enable automatic select,add,update,delete operations on that table. By default all columns of the table are selected on grid. We'll review how to select particular columns.</li> <li><code>-&gt;render()</code> will generate the final output, to be displayed in view. It takes Grid ID as input, which should be unique on a page.</li> </ul>"},{"location":"database-table-editor.html","title":"Database table editor","text":""},{"location":"database-table-editor.html#database-table-editor","title":"Database Table Editor","text":""},{"location":"databases-faqs.html","title":"Databases FAQs","text":""},{"location":"databases-faqs.html#databases-faqs","title":"Databases FAQs","text":""},{"location":"databases-faqs.html#q-for-sql-server-demos-i-get-mssqlnative-extension-not-installed-where-do-i-get-that-extension-so-i-can-view-that-demo","title":"Q) For SQL Server demos, I get \"mssqlnative extension not installed\".  Where do I get that extension so I can view that Demo?","text":"<p>Here is link from MS SQL Server website. http://www.microsoft.com/en-us/download/details.aspx?id=20098</p> <p>You need to enable the extension in php after installation.</p>"},{"location":"databases-faqs.html#q-how-to-use-mysqli-or-pdo-extension","title":"Q) How to use mysqli or PDO extension?","text":"<p>Here is the config settings.</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"mysqli\";\n$db_conf[\"server\"] = \"localhost\"; // or you mysql ip\n$db_conf[\"user\"] = \"root\"; // username\n$db_conf[\"password\"] = \"test\"; // password\n$db_conf[\"database\"] = \"griddemo\"; // database\n\n// include and create object\n$base_path = strstr(realpath(\".\"),\"demos\",true).\"lib/\";\ninclude($base_path.\"inc/jqgrid_dist.php\");\n$g = new jqgrid($db_conf);\n</code></pre> <p>After that, all calls will use mysqli extension.</p> <p>For PDO extension,</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"pdo\";\n$db_conf[\"server\"] = \"mysql:host=localhost\";\n$db_conf[\"user\"] = PHPGRID_DBUSER; // username\n$db_conf[\"password\"] = PHPGRID_DBPASS; // password\n$db_conf[\"database\"] = PHPGRID_DBNAME; // database\n\ninclude($base_path.\"inc/jqgrid_dist.php\");\n$g = new jqgrid($db_conf);\n</code></pre>"},{"location":"debug-mode.html","title":"Debug Mode","text":""},{"location":"debug-mode.html#debug-mode","title":"Debug Mode","text":"<p>Debug mode is enabled by default and it will show the server side failure reason. When going in production mode, you should disable the debug mode by following config.</p> <pre><code>$g = new jqgrid();\n$g-&gt;debug = 0;\n</code></pre> <p>If you wish to change the SQL errors, you can turn them off using following setting.</p> <pre><code>$g-&gt;error_msg = \"System was unable to process your request. Please contact technical support.\";\n</code></pre> <p>For custom message at server side data validation, refer demos/editing/server-validation.php</p> <p>In order to debug SQL queries, set:</p> <pre><code>$g-&gt;debug_sql = 1;\n</code></pre> <p>In order to debug Search queries, set:</p> <pre><code>$g-&gt;debug_search = 1;\n</code></pre> <p>By enabling <code>debug_sql</code> or <code>debug_search</code> configuration, you will see SQL queries being sent to database in error message box. You can also close error box and continue next debug step.</p>"},{"location":"debug-mode.html#resources","title":"Resources","text":"<ul> <li>See Reference</li> </ul>"},{"location":"dialog-customization-faqs.html","title":"Dialog Customization FAQs","text":""},{"location":"dialog-customization-faqs.html#dialog-customization-faqs","title":"Dialog Customization FAQs","text":""},{"location":"dialog-customization-faqs.html#q-how-to-get-direct-link-to-the-add-new-record-form-or-display-add-form-on-grid-load","title":"Q) How to get direct link to the add new record form OR display add form on grid load?","text":"<p>Following config will show add dialog on load, given that <code>list1</code> is grid id.</p> <pre><code>if ($_GET[\"showform\"]==\"add\")\n    $grid[\"loadComplete\"] = \"function(){ if (!jQuery(window).data('isFilled')) { jQuery(window).data('isFilled',true); jQuery('#add_list1').click(); } }\";\n\n$g-&gt;set_options($grid);\n</code></pre> <p>And it would show when you access url with querystring showform=add, e.g. http:///index.php?showform=add <p>To open edit dialog for first row on loading grid, you can set:</p> <pre><code>$grid[\"loadComplete\"] = \"function(){ if (!jQuery(window).data('isFilled')) { jQuery(window).data('isFilled',true); jQuery('#list1').setSelection( $('#list1').jqGrid('getDataIDs')[0] ); jQuery('#edit_list1').click(); } }\";\n\n$g-&gt;set_options($grid);\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-show-confirmation-before-close-add-or-edit-dialog","title":"Q) How to show Confirmation before close add or edit dialog?","text":"<p>Following config will show confirmation onclose event of dialogs.</p> <pre><code>$opt[\"edit_options\"][\"onClose\"] = \"function(){ return confirm('Are you sure you wish to close?'); }\";\n$opt[\"add_options\"][\"onClose\"] = \"function(){ return confirm('Are you sure you wish to close?'); }\";\n...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-save-record-with-previous-next-navidation","title":"Q) How to save record with Previous / Next navidation?","text":"<p>Following config will enable form navigation and save edit dialog on navigation.</p> <pre><code>$opt[\"form\"][\"nav\"] = true;\n$opt[\"edit_options\"][\"onclickPgButtons\"] = \"function (which, formid, rowid){ $('#sData','#editmodlist1').click(); }\";\n$opt[\"edit_options\"][\"closeAfterEdit\"] = false;\n...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-redirect-to-custom-page-after-add-update","title":"Q) How to redirect to custom page after add / update?","text":"<p>You can use <code>onAfterSave</code> event:</p> <pre><code>$opt[\"onAfterSave\"] = \"(function(){window.open('another_grid_page_here.php','_parent');})();\";\n</code></pre> <p>OR You can bind on_after_insert or on_after_update event handler which will redirect with following code:</p> <pre><code>$e[\"on_after_update\"] = array(\"redirect_page\",\"\",true);\n$g-&gt;set_events($e);\n\nfunction redirect_page($data)\n{\n    phpgrid_msg(\"Redirecting ...&lt;script&gt;location.href='http://google.com'&lt;/script&gt;\",0);\n}\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-add-custom-buttons-in-addedit-dialogs","title":"Q) How to add custom buttons in add/edit dialogs?","text":"<p>Following config will enable the addition of custom button in grid dialogs. You can edit button name 'Export' &amp; onclick function as per your needs. Refer working sample dialog-layout.php for live demo.</p> <pre><code>$opt[\"edit_options\"][\"afterShowForm\"] = 'function ()\n    {\n        $(\\'&lt;a href=\"#\"&gt;Export&lt;span class=\"ui-icon ui-icon-disk\"&gt;&lt;/span&gt;&lt;/a&gt;\\')\n        .addClass(\"fm-button ui-state-default ui-corner-all fm-button-icon-left\")\n        .prependTo(\"#Act_Buttons&gt;td.EditButton\")\n        .click(function()\n                {\n                    alert(\"click!\");\n                });\n    }';\n\n$opt[\"add_options\"][\"afterShowForm\"] = 'function ()\n    {\n        $(\\'&lt;a href=\"#\"&gt;Load Default&lt;span class=\"ui-icon ui-icon-disk\"&gt;&lt;/span&gt;&lt;/a&gt;\\')\n        .addClass(\"fm-button ui-state-default ui-corner-all fm-button-icon-left\")\n        .prependTo(\"#Act_Buttons&gt;td.EditButton\")\n        .click(function()\n                {\n                    alert(\"click!\");\n                });\n    }';\n\n$opt[\"search_options\"][\"afterShowSearch\"] = 'function ()\n        {\n            $(\\'&lt;a href=\"#\"&gt;Load Default&lt;span class=\"ui-icon ui-icon-disk\"&gt;&lt;/span&gt;&lt;/a&gt;\\')\n            .addClass(\"fm-button ui-state-default ui-corner-all fm-button-icon-left\")\n            .prependTo(\"td.EditButton:last\")\n            .click(function()\n                    {\n                        alert(\"click!\");\n                    });\n        }';\n...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-remove-toolbar-buttons-for-addedit-dialog-and-enable-only-inline-editing","title":"Q) How to remove toolbar buttons for add/edit dialog and enable only inline editing?","text":"<p>Use following config to remove toolbar buttons, while inline options remain intact. $g is jqgrid() object. The navgrid settings override set_actions configuration for toolbar.</p> <pre><code>$g-&gt;navgrid[\"param\"][\"edit\"] = false;\n$g-&gt;navgrid[\"param\"][\"add\"] = false;\n$g-&gt;navgrid[\"param\"][\"del\"] = false;\n</code></pre> <p>Additionally, if you wish to remove search &amp; refresh buttons, here is the code.</p> <pre><code>$g-&gt;navgrid[\"param\"][\"search\"] = false;\n$g-&gt;navgrid[\"param\"][\"refresh\"] = false;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-make-more-space-for-buttons-in-toolbar","title":"Q) How to make more space for buttons in toolbar?","text":"<p>An option could be to move the pager and total records from top toolbar. It will give full width space for icons. Along with that you can remove the operations buttons from bottom toolbar.</p> <pre><code>$opt[\"loadComplete\"] = \"function(){pagers_fx();}\";\n$g-&gt;set_options($opt);\n</code></pre> <p>and in html ...</p> <pre><code>&lt;script&gt;\n    var pagers_fx = function(){\n    jQuery(\".ui-jqgrid-toppager td[id$=pager_right]\").remove();\n    jQuery(\".ui-jqgrid-toppager td[id$=pager_center]\").remove();\n    jQuery(\".ui-jqgrid-pager td[id$=pager_left]\").html('');\n    };\n&lt;/script&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-can-i-remove-autofilter-and-toolbar-altogether","title":"Q) How can i remove autofilter and toolbar altogether?","text":"<p>You can apply following css onpage to hide them.</p> <pre><code>&lt;style&gt;\n.ui-jqgrid-hbox, .ui-jqgrid-pager\n{\n    display:none;\n}\n&lt;/style&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-show-view-record-dialog-on-row-selection","title":"Q) How to show \"View Record\" dialog on row selection?","text":"<p>Following code snippet will enable view dialog on row selection. This will be placed in before we echo $out variable.</p> <pre><code>&lt;script&gt;\nvar opts = {\n    'onSelectRow': function (id) {\n        jQuery(this).jqGrid('viewGridRow', id, jQuery(this).jqGrid('getGridParam','view_options'));\n    }\n};\n&lt;/script&gt;\n\n...\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-show-edit-record-dialog-on-row-double-click-show-dialog-on-row-edit-button","title":"Q) How to show \"Edit Record\" dialog on row double click / Show dialog on row edit button?","text":"<p>Following code snippet will enable edit dialog on row double click. This will be placed in before we echo $out variable. <code>$g</code> is the jqgrid() object.</p> <pre><code>&lt;script&gt;\nvar opts = {\n    'ondblClickRow': function (id) {\n        jQuery(this).jqGrid('editGridRow', id, jQuery(this).jqGrid('getGridParam','edit_options'));\n    }\n};\n&lt;/script&gt;\n...\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-show-view-record-dialog-on-row-double-click-show-dialog-on-row-edit-button","title":"Q) How to show \"View Record\" dialog on row double click / Show dialog on row edit button?","text":"<p>The loadComplete event is used to open edit dialog on row edit icon. (Inline editing is not supported) Code snippet with 'opts' will enable view dialog on row double click. This will be placed in before we echo $out variable.</p> <pre><code>$grid[\"loadComplete\"] = 'function() { on_load(); }';\n$g-&gt;set_options($grid);\n\n&lt;script&gt;\nfunction on_load()\n{\n    var gid = '&lt;?php echo $g-&gt;id ?&gt;';\n    jQuery('a.ui-custom-icon.ui-icon-pencil').attr('onclick','');\n    jQuery('a.ui-custom-icon.ui-icon-pencil').click(function(){ jQuery('#'+gid+'').jqGrid('setSelection',jQuery(this).closest('tr').attr('id'), true); jQuery('#edit_'+gid).click(); });\n};\n\nvar opts = {\n    'ondblClickRow': function (id) {\n        jQuery(this).jqGrid('viewGridRow', id, &lt;?php echo json_encode_jsfunc($g-&gt;options[\"view_options\"])?&gt;);\n    }\n};\n&lt;/script&gt;\n\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre> <p>In order to enable inline editing on pencil icon along with view dialog on dblclick, refer this code.</p>"},{"location":"dialog-customization-faqs.html#q-how-to-post-other-form-data-with-grid-addedit-form","title":"Q) How to post other form data with Grid add/edit form?","text":"<p>To add extra parameters while add/edit ...you can add following event. Here 'my_text_box' is html input field id, and it will be passed to php with name 'mydata'.</p> <pre><code>$opt[\"edit_options\"][\"onclickSubmit\"] = \"function(params, postdata) { postdata.mydata= jQuery('#my_text_box').val(); }\";\n$opt[\"add_options\"][\"onclickSubmit\"] = \"function(params, postdata) { postdata.mydata= jQuery('#my_text_box').val(); }\";\n...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-use-custom-dialog-box-with-button-on-grid","title":"Q) How to use custom dialog box with button on grid?","text":"<p>Support we have a virtual column that has input of type button as default value. We can simply set \"onclick\" in element attribute and invoke jQuery UI Dialog code.</p> <pre><code>$col[\"default\"] = '&lt;input type=\"button\" value=\"Open Dialog\" onclick=\"$(\\\"#wrapper\\\").dialog(\\\"open\\\");\"&gt;';\n</code></pre> <p>Given that there is a container 'wrapper' exist in html code.</p> <pre><code>&lt;div id=\"wrapper\"&gt;\n&lt;p&gt;Jquery initial content, can be replaced latter &lt;/p&gt;\n&lt;/div&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-make-2-column-form-without-defining-rowpos-colpos-only-with-css","title":"Q) How to make 2 column form without defining rowpos &amp; colpos, only with css?","text":"<p>You need to increase the dialog width using following settings:</p> <pre><code>$grid[\"add_options\"] = array('width'=&gt;'450');\n$grid[\"edit_options\"] = array('width'=&gt;'450');\n$g-&gt;set_options($grid);\n</code></pre> <p>Then define following css in html code:</p> <pre><code>&lt;style&gt;\n    /* Alternate way if we dont use formoptions */\n    .FormGrid .EditTable .FormData\n    {\n        float: left;\n        width: 220px;\n    }\n    .FormGrid .EditTable .FormData .CaptionTD\n    {\n        display: block;\n        float: left;\n        vertical-align: top;\n        width: 60px;\n    }\n    .FormGrid .EditTable .FormData .DataTD\n    {\n        display: block;\n        float: left;\n        vertical-align: top;\n        width: 140px;\n    }\n&lt;/style&gt;\n</code></pre> <p>You can adjust the width of caption, data and row as required.</p>"},{"location":"dialog-customization-faqs.html#q-how-to-resize-the-form-fields-when-dialog-is-resized","title":"Q) How to resize the form fields when dialog is resized?","text":"<p>Following css makes fields small/large based on available width on dialog.</p> <pre><code>&lt;style&gt;\n.FormElement { width: 90%; }\n.CaptionTD {width: 10%}\n&lt;/style&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-can-i-post-extra-data-along-with-form-fields","title":"Q) How can i POST extra data along with form fields?","text":"<p>You can pass extra parameters in following way, both for dialog and inline modes.</p> <pre><code>// extra param 'test' =&gt; 'test-add'\n$grid[\"add_options\"][\"editData\"][\"test\"] = \"test-add\";\n$grid[\"edit_options\"][\"editData\"][\"test\"] = \"test-edit\";\n$grid[\"delete_options\"][\"delData\"][\"test\"] = \"test-del\";\n\n$g-&gt;set_options($grid);\n</code></pre> <p>As all posted data is made part of insert/update/delete query, you may need to unset them in event handler. Refer demos/editing/custom-events.php for event handler usage.</p>"},{"location":"dialog-customization-faqs.html#q-how-to-use-custom-add-form-instead-of-popup-dialog","title":"Q) How to use custom Add form instead of popup dialog?","text":"<p>One solution could be to add a custom toolbar button, and hide the default add function. On that custom toolbar button, redirect page to your add-form.php page. And on add-form.php page, after submit you can redirect it back to grid page.</p> <p>To remove add button, You can set:</p> <pre><code>$g-&gt;set_actions(array(\n    \"add\"=&gt;false, // allow/disallow add\n    ...\n    )\n);\n</code></pre> <p>To add custom toolbar button, refer demos/appearance/toolbar-button.php</p> <pre><code>&lt;script type=\"text/javascript\"&gt;\njQuery(document).ready(function(){\n\n    jQuery('#list1').jqGrid('navButtonAdd', '#list1_pager',\n    {\n        'caption'      : 'Add',\n        'buttonicon'   : 'ui-icon-plus',\n        'onClickButton': function()\n        {\n            location.href=\"custom-add-form.php\";\n        },\n        'position': 'first'\n    });\n});\n&lt;/script&gt;\n</code></pre> <p>Same procedure can use used for custom edit form. You can also pass selected row id as querystring param. Following will be the code in onclick handler:</p> <pre><code>var selr = jQuery('#list1').jqGrid('getGridParam','selrow');\nlocation.href=\"custom-edit-form.php?id=\"+selr;\n</code></pre> <p>Another method is to change the onclick event of existing add/edit buttons.</p> <p>Connect a callback on loadComplete event:</p> <pre><code>$opt[\"loadComplete\"] = 'function() { on_load(); }';\n$g-&gt;set_options($opt);\n</code></pre> <p>And in callback function, unbind and rebind the add / edit toolbar buttons.</p> <pre><code>&lt;script&gt;\nfunction on_load()\n{\n    var gid = '&lt;?php echo $g-&gt;id ?&gt;';\n\n    jQuery('#edit_list1').unbind('click');\n    jQuery('#edit_list1').click(function(){\n\n        var rows = '';\n        if (jQuery('#list1').jqGrid('getGridParam','multiselect'))\n            rows = jQuery('#list1').jqGrid('getGridParam','selarrrow');\n        else\n            rows = jQuery('#list1').jqGrid('getGridParam','selrow');\n\n        if (rows == '')\n        {\n            jQuery.jgrid.info_dialog(jQuery.jgrid.nav.alertcap,'&lt;div class=\"ui-state-default\" style=\"padding:5px;\"&gt;'+jQuery.jgrid.nav.alerttext+'&lt;/div&gt;',\n                                        jQuery.jgrid.edit.bClose,{buttonalign:'right'});\n            return;\n        }\n\n        window.open(\"edit.php?rows=\"+rows);\n\n    });\n\n    jQuery('#add_list1').unbind('click');\n    jQuery('#add_list1').click(function(){ \n        window.open(\"add.php\");\n    });\n};\n&lt;/script&gt;\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-select-text-on-focus-tab","title":"Q) How to select text on focus / tab?","text":"<p>You can call select() function of JS on click event.</p> <pre><code>$col[\"editoptions\"][\"onclick\"] = \"this.focus(); this.select();\";\n</code></pre>"},{"location":"dialog-customization-faqs.html#q-how-to-change-the-order-or-remove-the-search-operands-in-search-dialog","title":"Q) How to change the order OR remove the search operands in search dialog?","text":"<p>You can try setting it in your grid code:</p> <pre><code>// contains, equal, not equal, less than, greater than, greater and equal, less and equal, begins with, not behins with, IN, not IN, ends with, not ends with, not contains, null, not null\n$opt[\"searchoptions\"][\"sopt\"] = array('cn','eq','ne','lt','le','gt','ge','bw','bn','in','ni','ew','en','nc','nu','nn');\n$g-&gt;set_options($opt);\n</code></pre> <p>Here $g is grid object. You can also remove which are not required.</p>"},{"location":"export-faqs.html","title":"Export FAQs","text":""},{"location":"export-faqs.html#export-faqs","title":"Export FAQs","text":""},{"location":"export-faqs.html#q-how-to-export-japanese-multibyte-characters-shown","title":"Q) How to export japanese multibyte characters (??? shown) ?","text":"<p>You need to change font of export for that.</p> <p>Goto jqgrid_dist.php, Search for line</p> <pre><code>$pdf-&gt;SetFont('helvetica', '', 14);\n</code></pre> <p>and replace it with</p> <pre><code>$pdf-&gt;SetFont('cid0jp', '', 14);\n</code></pre> <p>For DejavuSans UTF8 font, following these steps:</p> <pre><code>1. Download the fonts archive (tcpdf_fonts_6_0_099.zip) from `http://sourceforge.net/projects/tcpdf/files/`\n2. Extract the fonts in lib/inc/tcpdf/fonts\n3. Set font in jqgrid_dist.php\n\n$pdf-&gt;SetFont('dejavusans', '', 14, '', true);\n</code></pre> <p>For RTL languages text, html renderer must also be used along with rtl font.</p> <pre><code>$opt[\"export\"][\"render_type\"] = \"html\";\n</code></pre> <p>In case of missing font, contact me back for updated lib.</p>"},{"location":"export-faqs.html#q-how-to-override-default-pdf-settings","title":"Q) How to override default PDF settings ?","text":"<p>You can use on_render_pdf event handler to get TCPDF object, and change settings accordingly. For e.g. to change font,</p> <pre><code>$e[\"on_render_pdf\"] = array(\"set_pdf_format\", null);\n$g-&gt;set_events($e);\n\nfunction set_pdf_format($arr)\n{\n    $pdf = $arr[\"pdf\"];\n    $data = $arr[\"data\"];\n    $pdf-&gt;SetFont('dejavusans', '', 10);\n    $pdf-&gt;SetLineWidth(0.1);\n}\n</code></pre>"},{"location":"export-faqs.html#q-getting-error-on-pdf-export-tcpdf-error-some-data-has-already-been-output-cant-send-pdf-file","title":"Q) Getting error on PDF export, \"TCPDF ERROR: Some data has already been output, can't send PDF file\"","text":"<p>There are usually 2 reasons for this.</p> <p>1) Blank space character at start of grid file (new line etc) 2) Invisible BOM character at start of file</p> <p>In case #1 will give header already sent error. #2 will push all data as html text.</p> <p>White spaces can be removed by checking top and end of all included files. To remove invisible BOM character, i would recommend Notepad++ -&gt; Open file -&gt; Encoding menu -&gt; Encode UTF without BOM</p>"},{"location":"export-faqs.html#q-how-to-use-custom-export-method-external-file","title":"Q) How to use custom export method (external-file) ?","text":"<p>You can use on_export event, to do your custom export working. An example is given below</p> <pre><code>// params are array(&lt;function-name&gt;,&lt;class-object&gt; or &lt;null-if-global-func&gt;,&lt;continue-default-operation&gt;)\n$e[\"on_export\"] = array(\"custom_export\", NULL, false);\n$g-&gt;set_events($e);\n\n// custom on_export callback function. Set all useful data in session for custom export code file\nfunction custom_export($param)\n{\n    $sql = $param[\"sql\"]; // the SQL statement for export\n    $grid = $param[\"grid\"]; // the complete grid object reference\n\n    if ($grid-&gt;options[\"export\"][\"format\"] == \"xls\")\n    {\n        $_SESSION[\"phpgrid_sql\"]=$sql;\n        $_SESSION[\"phpgrid_filename\"]=$grid-&gt;options[\"export\"][\"filename\"];\n        $_SESSION[\"phpgrid_heading\"]=$grid-&gt;options[\"export\"][\"heading\"];\n\n        $cols_skip = array();\n        $titles = array();\n\n        foreach ($grid-&gt;options[\"colModel\"] as $c)\n        {\n            if ($c[\"export\"] === false)\n                $cols_skip[] = $c[\"name\"];\n\n            $titles[$c[\"index\"]] = $c[\"title\"];\n        }\n\n        $_SESSION[\"phpgrid_cols_skip\"]=serialize($cols_skip);\n        $_SESSION[\"phpgrid_cols_title\"]=serialize($titles);\n\n        header(\"Location: my-export.php\");\n        die();\n    }\n}\n</code></pre> <p>In that redirected file (my-export.php), you can use all session variable to fetch data from DB and export as desired.</p>"},{"location":"export-faqs.html#q-how-to-customize-pdf-header-and-footer","title":"Q) How to customize PDF header and footer?","text":"<p>Goto file 'lib/inc/tcpdf/class.easytable.php', at end of file, there are 2 empty function header() and footer(). You can put image and text there using TCPDF lib sample code: http://www.tcpdf.org/examples/example_003.phps</p>"},{"location":"export-faqs.html#q-how-to-show-logo-on-exported-pdf","title":"Q) How to show Logo on exported PDF ?","text":"<p>You can check TCPDF documentation and modify class 'lib/inc/tcpdf/class.easytable.php', go to end of file, Have header function empty, You can put image and text. In similar way, one can put footer.</p> <p>Also check this forum post.</p>"},{"location":"export-faqs.html#q-how-to-show-searched-string-as-heading-in-pdf","title":"Q) How to show searched string as heading in PDF ?","text":"<pre><code>$e[\"on_export\"] = array(\"set_header\", null,true);\n$g-&gt;set_events($e);\n\nfunction set_header($d)\n{\n    // search params\n    $search_str = $d[\"grid\"]-&gt;strip($_SESSION['jqgrid_filter_request']);\n    $search_arr = json_decode($search_str,true);\n    $gopr = $search_arr['groupOp'];\n    $rule = $search_arr['rules'][0];\n\n    if (!empty($rule[\"data\"]))\n        $d[\"grid\"]-&gt;options[\"export\"][\"heading\"] = $rule[\"data\"];\n}\n</code></pre>"},{"location":"export-faqs.html#q-how-to-can-i-resolve-class-ziparchive-not-found","title":"Q) How to can i resolve: Class 'ZipArchive' not found?","text":"<p>On blank export and on checking error_log if you see \"PHP Fatal error:  Class 'ZipArchive' not found in /home/user/public_html/phpgrid/lib/inc/excel/PHPExcel/Writer/Excel2007.php on line 225\"</p> <p>There are 2 options for fix.</p> <p>First is it to install zip php extension that is required by phpexcel library. Other one is to rename 'PHPExcel' folder in /lib/inc/excel/ with '_PHPExcel' <p>If this path is not found, our system uses older excel exporting library which might work without zip extension.</p>"},{"location":"exporting-data.html","title":"Exporting Data","text":""},{"location":"exporting-data.html#exporting-data","title":"Exporting Data","text":"<p><code>format</code> could be     - <code>pdf</code>     - <code>excel</code>     - <code>csv</code>     - <code>html</code> <code>heading</code> is used as Heading of pdf file. <code>orientation</code> is page orientation. Could be <code>landscape</code> or <code>portrait</code>. <code>paper</code> values could be 4a0,2a0,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,b0,b1,                         b2,b3,b4,b5,b6,b7,b8,b9,b10,c0,c1,c2,c3,c4,c5,                         c6,c7,c8,c9,c10,ra0,ra1,ra2,ra3,ra4,sra0,sra1,                         sra2,sra3,sra4,letter,legal,ledger,tabloid,executive,                         folio,commercial #10 envelope,catalog #10 1/2 envelope,                         8.5x11,8.5x14,11x17</p> <pre><code>$opt[\"export\"] = array(\"format\"=&gt;\"pdf\", \"filename\"=&gt;\"my-file\", \"sheetname\"=&gt;\"test\");\n$opt[\"export\"] = array(\"filename\"=&gt;\"my-file\", \"heading\"=&gt;\"Invoice Details\", \"orientation\"=&gt;\"landscape\", \"paper\"=&gt;\"a4\");\n</code></pre> <p>Setting <code>paged</code> to <code>1</code> will only export current page.</p> <pre><code>$opt[\"export\"][\"paged\"] = \"1\";\n</code></pre> <p>Export all data which is fetched by SQL, or export after applying search filters (if any) Possible values are <code>filtered</code> or <code>all</code>.</p> <pre><code>$opt[\"export\"][\"range\"] = \"filtered\";\n</code></pre> <p>When exporting PDF, if you define column width, you need to set width of all columns. Setting width for few and leaving few will make export column width distorted. In order to make it independent of $col[\"width\"] and adjust equally in pdf, you can set:</p> <pre><code>$grid[\"export\"][\"colwidth\"] = \"equal\";\n</code></pre> <p>You can also set certain column not to export by setting export option to false. e.g.</p> <pre><code>$col[\"export\"] = false;\n</code></pre> <p>You can also add export buttons on toolbar by:</p> <pre><code>$g = new jqgrid($conf);\n// ...\n$g-&gt;set_actions(array(\n                        \"add\"=&gt;true,\n                        \"edit\"=&gt;true,\n                        // ...\n                        \"export_pdf\"=&gt;true,\n                        \"export_excel\"=&gt;true,\n                        \"export_csv\"=&gt;true,\n                        \"export_html\"=&gt;true\n                    )\n                );\n</code></pre>"},{"location":"exporting-data.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/export/export-all.php</code></li> </ul>"},{"location":"footer-summary.html","title":"Footer Summary","text":""},{"location":"footer-summary.html#footer-summary","title":"Footer Summary","text":"<p>Step1: Enable footer in grid options and connect grid load event.</p> <pre><code>$opt[\"footerrow\"] = true;\n$opt[\"loadComplete\"] = \"function(){ grid_onload(); }\";\n$g-&gt;set_options($opt);\n</code></pre> <p>Step2: Write JS code to fill footer row.</p> <pre><code>&lt;script&gt;\n// e.g. to show footer summary\nfunction grid_onload()\n{\n    // where list1 is grid id\n    var grid = $(\"#list1\");\n\n    // get sum of column `total`\n    // can use other functions like 'sum, 'avg', 'count' (use count-1 as it count footer row).\n    var sum = grid.jqGrid('getCol', 'total', false, 'sum');\n\n    // set in footer under another column 'id'\n    grid.jqGrid('footerData','set', {id: 'Total: ' + sum});\n};\n&lt;/script&gt;\n</code></pre> <p>If using formatter in columns (like currency etc), you need to pass 4th param to false. e.g.</p> <pre><code>grid.jqGrid('footerData','set', { id: 'Total: \u20ac' + sum.toFixed(2) }, false);\n</code></pre> <p>For more advanced example, refer sample code below.</p>"},{"location":"footer-summary.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/footer-row.php</code></li> </ul>"},{"location":"general-faqs.html","title":"General FAQs","text":""},{"location":"general-faqs.html#general-faqs","title":"General FAQs","text":""},{"location":"general-faqs.html#q-how-to-debug-no-records-blank-grid","title":"Q) How to debug no records (blank grid)?","text":"<p>Few considerations before use</p> <p>1)  include the jqgrid_dist.php file before any thing rendered to output. 2)  Check the ajax response of grid,</p> <p>Also make sure you call '$g-&gt;render();' function before any HTML is rendered (echo'd) to output, as it expect exact JSON format for ajax calls. You can echo the output of render() function to desired location in html.</p> <p>Use firefox-&gt;firebug-&gt;net-&gt;ajax-call of grid-&gt;response. You will see the output there, in case of any error. It should be proper JSON format data in order to render grid</p> <p>Review this tutorial for 'debugging with firebug'.</p> <p>To enable debugging errors,</p> <p>1) Turn errors on. Goto jqgrid_dist.php make it 'on'</p> <pre><code>ini_set(\"display_errors\",\"on\"); // changed from off to on\n</code></pre> <p>2) If you are using non-mysql database,</p> <pre><code>$g = new jqgrid($db);\n...\n$g-&gt;con-&gt;debug = 1;\n</code></pre>"},{"location":"general-faqs.html#q-how-can-i-integrate-grid-4-php-in-mvc-based-frameworks-like-laravel-yii-codeignitor-zend-framework-cakephp-and-others","title":"Q) How can i integrate Grid 4 PHP in MVC based frameworks like Laravel, Yii, Codeignitor, Zend Framework, CakePHP and others.","text":"<p>To integrate in MVC, You can divide code in 2 sections. And put first in controller and pass the $out variable to view, where you can render it with rest of JS/CSS files.</p> <p>CONTROLLER PART</p> <pre><code>include(\"inc/jqgrid_dist.php\");\n$g = new jqgrid();\n...\n$out = $g-&gt;render(\"list1\");\n</code></pre> <p>VIEW PART</p> <pre><code>&lt;html&gt;\n\n&lt;link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"js/themes/redmond/jquery-ui.custom.css\"&gt;&lt;/link&gt;\n&lt;link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"js/jqgrid/css/ui.jqgrid.css\"&gt;&lt;/link&gt;\n\n&lt;script src=\"js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"js/jqgrid/js/i18n/grid.locale-en.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"js/jqgrid/js/jquery.jqGrid.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"js/themes/jquery-ui.custom.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n\n...\n</code></pre> <p>PHP Grid works independently from the framework lib and don't use data access layers of framework. In Codeigniter, the htaccess mod_rewrite param of QSA (query string append) is disabled. You might need to enable it in CI <code>.htaccess</code> file.</p> <pre><code>RewriteEngine On\nRewriteCond %{REQUEST_FILENAME} !-f\nRewriteCond %{REQUEST_FILENAME} !-d\nRewriteRule ^(.*)$ index.php/$1 [QSA,L]\n</code></pre>"},{"location":"general-faqs.html#q-grid-only-show-editdelete-option-only-on-first-row-certain-rows","title":"Q) Grid only show Edit/Delete option only on first row / certain rows?","text":"<p>The first column of grid must have unique alphanumeric data (usually a PK). This is required for proper display as well as update &amp; delete operations of particular row. Later, You can also hide that column by setting $col[\"hidden\"] = true;</p>"},{"location":"general-faqs.html#q-im-getting-js-error-in-browser-console-jqgrid-is-undefined-or-cannot-read-property-bridge-of-undefined","title":"Q) I'm getting JS error in browser console: 'jqGrid' is undefined OR Cannot read property 'bridge' of undefined?","text":"<p>It's usually due to order of including jQuery JS file OR possibly duplicate inclusion. Please see below. </p> <p>Correct: Including jQuery before jqGrid JS file</p> <pre><code>&lt;script src=\"../../lib/js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/i18n/grid.locale-en.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/jquery.jqGrid.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/themes/jquery-ui.custom.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>Incorrect: Not Including before jqGrid js file</p> <pre><code>&lt;script src=\"../../lib/js/jqgrid/js/i18n/grid.locale-en.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/jquery.jqGrid.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/themes/jquery-ui.custom.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>Incorrect: Including jQuery twice, by theme template or other plugin</p> <pre><code>&lt;script src=\"../../lib/js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/i18n/grid.locale-en.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/jquery.jqGrid.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/themes/jquery-ui.custom.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n\n&lt;!-- some other code --&gt;\n\n&lt;script src=\"&lt;some-other-plugin&gt;/js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>Make sure you include JQuery JS file before other JS files and include only once in your page. </p>"},{"location":"general-faqs.html#q-how-to-display-grid-with-no-primary-key-in-table","title":"Q) How to display grid with no primary key in table?","text":"<p>You can virtual column for unique data as first column of grid, and fill that column using filter_display event. It is required for various options e.g. displaying subgrid etc.</p> <pre><code>// virtual column to show grid\n\n$col = array();\n$col[\"title\"] = \"Id\";\n$col[\"name\"] = \"vid\";\n$col[\"width\"] = \"400\";\n$col[\"hidden\"] = true;\n$cols[] = $col;\n\n$e[\"on_data_display\"] = array(\"filter_display\", null, true);\n$g-&gt;set_events($e);\n\nfunction filter_display($data)\n{\n    $i=1;\n    foreach($data[\"params\"] as &amp;$d)\n    {\n        $d[\"vid\"] = $i++;\n    }\n}\n</code></pre>"},{"location":"grid-appearance-faqs.html","title":"Grid Appearance FAQs","text":""},{"location":"grid-appearance-faqs.html#grid-appearance-faqs","title":"Grid Appearance FAQs","text":""},{"location":"grid-appearance-faqs.html#q-i-upgraded-to-licensed-version-why-i-am-having-free-version-tag-line-with-grid","title":"Q) I upgraded to licensed version. Why i am having 'Free Version' tag line with grid?","text":"<p>Try following steps.</p> <p>1) Please make sure you have replaced lib/js folder with the one in licensed packgage.</p> <p>2) Your browser is using cached JS files. Try after clearing browser cached files. You can also try opening it in different browser OR browser's incognito mode. </p>"},{"location":"grid-appearance-faqs.html#q-how-to-show-horizontal-scroll-bar-in-grid-when-there-are-many-columns","title":"Q) How to show horizontal scroll bar in grid (when there are many columns) ?","text":"<p>You need to set following params:</p> <pre><code>$grid[\"autowidth\"] = false;\n$grid[\"responsive\"] = false;\n$grid[\"shrinkToFit\"] = false; // dont shrink (or extend) to fit in grid width\n$grid[\"width\"] = \"600\";\n...\n$g-&gt;set_options($grid);\n</code></pre> <p>For 2.6.2+,</p> <pre><code>$grid[\"cmTemplate\"][\"visible\"] = \"xs+\"; // show all column on small screens\n$grid[\"shrinkToFit\"] = false; // enable horizontal scrollbar\n...\n$g-&gt;set_options($grid);\n</code></pre> <p>If you dont specify the width property, it will be the sum of all columns width. To make scroll bar visible, the sum of column width must increase window width.</p>"},{"location":"grid-appearance-faqs.html#q-change-font-size-height-of-cell","title":"Q) Change font size &amp; height of cell","text":"<p>Update following css classes to change presentation.</p> <pre><code>&lt;style&gt;\n.ui-jqgrid {font-size:14px; font-family:\"tahoma\";}\n.ui-jqgrid tr.jqgrow td {height: 25px; padding:0 5px !important;}\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-show-vertical-lines-for-each-column","title":"Q) How to show vertical lines for each column?","text":"<p>You can add following CSS code to show vertial lines in datagrid.</p> <pre><code>&lt;style&gt;\n.ui-jqgrid tr.ui-row-ltr td { border-right-style:inherit !important; }\n.ui-jqgrid tr.ui-row-rtl td { border-left-style:inherit !important; }\n/* To disable minimum grid height limit */\n.ui-jqgrid .ui-jqgrid-bdiv { min-height:10px; }\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-do-word-wrap-fit-content-in-grid-cells","title":"Q) How to do word-wrap (fit) content in grid cells?","text":"<p>Update following css in page to change cell wrapping.</p> <pre><code>&lt;style&gt;\n.ui-jqgrid tr.jqgrow td\n{\n    vertical-align: top;\n    white-space: normal !important;\n    padding:2px 5px;\n}\n&lt;/style&gt;\n</code></pre> <p>To make word wrapping in view record dialog, add following css:</p> <pre><code>&lt;style&gt;\n.ui-jqdialog-content .CaptionTD\n{\n    vertical-align: top;\n}\n\n.ui-jqdialog-content .form-view-data\n{\n    white-space: normal;\n}\n&lt;/style&gt;\n</code></pre> <p>Also check this link for frozen columns with cell wrap. http://stackoverflow.com/questions/8686616/how-can-i-get-jqgrid-frozen-columns-to-work-with-word-wrap-on</p>"},{"location":"grid-appearance-faqs.html#q-how-can-i-add-caption-along-with-icons-of-addeditdelete","title":"Q) How can i add caption along with icons of add,edit,delete.","text":"<p>You can set it using following config on jqgrid() object. For example:</p> <pre><code>$grid-&gt;navgrid[\"param\"][\"addtext\"] = \"Add Invoice\";\n$grid-&gt;navgrid[\"param\"][\"edittext\"] = \"Edit Invoice\";\n$grid-&gt;navgrid[\"param\"][\"deltext\"] = \"Delete Invoice\";\n$grid-&gt;navgrid[\"param\"][\"searchtext\"] = \"Search\";\n$grid-&gt;navgrid[\"param\"][\"refreshtext\"] = \"Refresh\";\n$grid-&gt;navgrid[\"param\"][\"viewtext\"] = \"View Invoice\";\n</code></pre> <p>Altenrate, You need to put following additional JS and CSS code. You can change 'Add User' with your desired caption.</p> <pre><code>&lt;script type=\"text/javascript\"&gt;\n$.jgrid.nav.addtext = \"Add User\";\n$.jgrid.nav.edittext = \"Edit User\";\n$.jgrid.nav.deltext = \"Delete User\";\n&lt;/script&gt;\n</code></pre> <p>After adding captions, the alignment got it out, so put this css.</p> <pre><code>&lt;style type=\"text/css\"&gt;\n.ui-jqgrid .ui-jqgrid-pager .ui-pg-div\n{\n    float: left;\n    line-height: 18px;\n    padding: 2px 2px 2px 0;\n    position: relative;\n}\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-enable-footer-summary-row","title":"Q) How to enable footer summary row?","text":"<p>Please do these changes to enable footer summary row.</p> <p>Step1: Enable footer row in options</p> <pre><code>$grid[\"footerrow\"] = true;\n$g-&gt;set_options($grid);\n\n// set onload js event\n$e[\"js_on_load_complete\"] = \"grid_onload\";\n$grid-&gt;set_events($e);\n</code></pre> <p>Step2: Add custom JS code as mentioned. 'list1' is the identifier for grid. In function 'getCol', 2nd param 'field1' is the name of column, which will show the summary data. Valid options for mathoperation (4th param) are - 'sum, 'avg', 'count'.</p> <pre><code>&lt;script&gt;\nfunction grid_onload()\n{\n    var grid = $(\"#list1\"),\n    sum = grid.jqGrid('getCol', 'field1', false, 'sum');\n    grid.jqGrid('footerData','set', {field1: 'Total: '+sum});\n}\n&lt;/script&gt;\n</code></pre> <p>If one need to show complete table's total in footer, refer following example.</p> <pre><code>$g-&gt;select_command = \"SELECT id,invdate,total,(SELECT sum(total) from invheader) AS table_total FROM invheader\";\n</code></pre> <p>Define a column with name table_total, and in footer data, use that table_total field.</p> <pre><code>&lt;script&gt;\nfunction grid_onload()\n{\n    var grid = $(\"#list1\");\n    sum = grid.jqGrid('getCol', 'table_total');\n    grid.jqGrid('footerData','set', {total: 'Total: '+sum[0]});\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-remove-buttons-and-text-from-toolbar","title":"Q) How to remove buttons and text from toolbar?","text":"<p>Do following config to show/remove items in toolbar</p> <pre><code>$opt[\"rowList\"] = array();\n$opt[\"pgbuttons\"] = false;\n$opt[\"pgtext\"] = null;\n$opt[\"viewrecords\"] = false;\n$g-&gt;set_options($opt);\n\n$g-&gt;set_actions(array(\n                        \"add\"=&gt;false, // allow/disallow add\n                        \"edit\"=&gt;false, // allow/disallow edit\n                        \"delete\"=&gt;false, // allow/disallow delete\n                        \"view\"=&gt;false, // allow/disallow view\n                        \"refresh\" =&gt; false, // show/hide refresh button\n                        \"search\" =&gt; false, // show single/multi field search condition (e.g. simple or advance)\n                    )\n                );\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-remove-caption-toolbars-column-label-rows-from-grid","title":"Q) How to remove caption, toolbars, column label rows from grid?","text":"<p>To remove the caption row, set grid caption property to blank.</p> <pre><code>$opt[\"caption\"] = \"\";\n</code></pre> <p>To remove the toolbars in subgrid, add following css in style tag after include the css files - where list1 is grid id of parent.</p> <pre><code>.ui-jqgrid[id^=gbox_list1_] .ui-pager-control { display: none; }\n</code></pre> <p>To remove the column labels,</p> <pre><code>.ui-jqgrid[id^=gbox_list1_] .ui-jqgrid-labels { display: none; }\n</code></pre> <p>To remove the search filters, set autofilter to false. e.g.</p> <pre><code>$g-&gt;set_actions(array(\n                        \"add\"=&gt;false, // allow/disallow add\n                        \"edit\"=&gt;true, // allow/disallow edit\n                        \"delete\"=&gt;false, // allow/disallow delete\n                        \"rowactions\"=&gt;true, // show/hide row wise edit/del/save option\n                        \"autofilter\" =&gt; false, // show/hide autofilter for search\n                    )\n                );\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-remove-global-search-and-enable-paging-buttons-on-top-toolbar","title":"Q) How to remove global search and enable paging buttons on top toolbar?","text":"<p>Following option will hide global search from top toolbar:</p> <pre><code>$opt[\"globalsearch\"] = false;\n$g-&gt;set_options($opt);\n</code></pre> <p>In html code:</p> <pre><code>&lt;style&gt;\n/* removed paging and record count from top pager */\n.ui-jqgrid .ui-jqgrid-toppager &gt; div &gt; table:nth-child(1) &gt; tbody &gt; tr &gt;  td:nth-child(2) { display:table-cell !important; }\n.ui-jqgrid .ui-jqgrid-toppager &gt; div &gt; table:nth-child(1) &gt; tbody &gt; tr &gt;  td:nth-child(3) { display:table-cell !important; }\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-caption-header-and-both-toolbars-altogether","title":"Q) How to caption header and both toolbars altogether?","text":"<p>Use this config:</p> <p>In grid settings:</p> <pre><code>$opt[\"caption\"] = \"\";\n$opt[\"height\"] = \"100%\";\n$g-&gt;set_options($opt);\n</code></pre> <p>In html code:</p> <pre><code>&lt;style&gt;\n.ui-jqgrid-pager,.ui-jqgrid-toppager\n{ display: none; }\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-left-button-group-from-bottom-toolbar","title":"Q) How to left button group from bottom toolbar?","text":"<p>In html code, add following css:</p> <pre><code>&lt;style&gt;\n.ui-jqgrid-pager td[id$='pager_left'] {\n    display: none;\n}\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-do-grouping-on-more-than-1-field","title":"Q) How to do grouping on more than 1 field?","text":"<p>It's not fully stable, but you can try following config.</p> <pre><code>$grid[\"grouping\"] = true;\n$grid[\"groupingView\"] = array();\n\n$grid[\"groupingView\"][\"groupField\"] = array(\"field1\",\"field2\"); // specify column name to group listing\n$grid[\"groupingView\"][\"groupDataSorted\"] = array(true,true); // show sorted data within group\n$grid[\"groupingView\"][\"groupSummary\"] = array(true,true); // work with summaryType, summaryTpl, see column: $col[\"name\"] = \"total\";\n\n$grid[\"groupingView\"][\"groupColumnShow\"] = array(false,false); // either show grouped column in list or not (default: true)\n$grid[\"groupingView\"][\"groupText\"] = array(\"&lt;b&gt;{0} - {1} Item(s)&lt;/b&gt;\"); // {0} is grouped value, {1} is count in group\n$grid[\"groupingView\"][\"groupOrder\"] = array(\"asc\"); // show group in asc or desc order\n$grid[\"groupingView\"][\"groupCollapse\"] = true; // Turn true to show group collapse (default: false)\n$grid[\"groupingView\"][\"showSummaryOnHide\"] = true; // show summary row even if group collapsed (hide)\n</code></pre> <p>Refer demos/appearence/grouping.php for more help.</p>"},{"location":"grid-appearance-faqs.html#q-how-to-do-grouping-collapse-except-first","title":"Q) How to do grouping collapse except first?","text":"<p>You can call click() of first group on load event of datagrid.</p> <pre><code>$opt[\"loadComplete\"] = \"function(){ $('.jqgroup:first span').click(); }\";\n// ...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-maintain-vertical-scroll-position-after-grid-reload","title":"Q) How to maintain vertical scroll position after grid reload?","text":"<p>First you need to get the handler for load complete.</p> <pre><code>$e[\"js_on_load_complete\"] = \"do_onload\";\n$g-&gt;set_events($e);\n</code></pre> <p>Then in callback, you can have following code.</p> <pre><code>&lt;script&gt;\nfunction do_onload()\n{\n    if (jQuery(window).data('phpgrid_scroll'))\n        jQuery('div.ui-jqgrid-bdiv').scrollTop(jQuery(window).data('phpgrid_scroll'));\n\n    jQuery('div.ui-jqgrid-bdiv').scroll(function(){\n        jQuery(window).data('phpgrid_scroll',jQuery('div.ui-jqgrid-bdiv').scrollTop());\n    });\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-scroll-to-a-particular-row-value-after-grid-reload","title":"Q) How to scroll to a particular row value after grid reload?","text":"<p>First you need to get the handler for load complete.</p> <pre><code>$e[\"js_on_load_complete\"] = \"do_onload\";\n$g-&gt;set_events($e);\n</code></pre> <p>Then in JS callback, you can have following code. This will iterate all rows and find row with name 'Victoria Ashworth'. It then uses row's first column 'client_id' to get  id and focus it with scrollTop(). <pre><code>&lt;script&gt;\nfunction do_onload()\n{\n    var rows =  $('#list1').getRowData();\n    for (var i=0;i&lt;rows.length;i++)\n        if (rows[i].name == 'Victoria Ashworth')\n        {\n            var t = jQuery('tr.jqgrow[id='+rows[i].client_id+']').position().top;\n            jQuery('div.ui-jqgrid-bdiv').scrollTop(t);\n        }\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-highlight-some-cell-based-on-row-data","title":"Q) How to highlight some cell based on row data ?","text":"<p>You can do it onload event of grid. First you need to connect event, and then write your desired logic in JS code.</p> <p>In Grid config, set event callback.</p> <pre><code>$e[\"js_on_load_complete\"] = \"do_onload\";\n...\n$grid-&gt;set_events($e);\n</code></pre> <p>In callback function, write your code.</p> <pre><code>function do_onload()\n{\n    var grid = $(\"#list1\");\n    var ids = grid.jqGrid('getDataIDs');\n    for (var i=0;i&lt;ids.length;i++)\n    {\n        var id=ids[i];\n        if (grid.jqGrid('getCell',id,'qty') == '0')\n        {\n            grid.jqGrid('setCell',id,'price','','not-editable-cell'); // make cell uneditable\n            grid.jqGrid('setCell',id,'price','',{'background-color':'lightgray'}); // make bgcolor to gray\n        }\n    }\n}\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-apply-formatting-of-rows-based-on-2-or-more-fields","title":"Q) How to apply formatting of rows, based on 2 or more fields.","text":"<p>You can use a load complete callback handler, and put conditional formatting JS code in it. For instance, refer following example, where list1 is grid id.</p> <pre><code>// PHP part\n$e[\"js_on_load_complete\"] = \"do_onload\";\n...\n$grid-&gt;set_events($e);\n\n// HTML part\n&lt;script&gt;\nfunction do_onload(ids)\n{\n    if(ids.rows) jQuery.each(ids.rows,function(i){\n\n        // format row when gender is 'male' and company name starts with 'Bl'\n        if (this.gender.toLowerCase() == 'male' &amp;&amp; this.company.indexOf('Bl') != -1)\n        {\n            jQuery('#list1 tr.jqgrow:eq('+i+')').css('background','inherit').css({'background-color':'#FBEC88', 'color':'green'});\n        }\n    });\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-show-dropdownselect-in-buttons-toolbar","title":"Q) How to show dropdown/select in buttons toolbar?","text":"<p>Following JS code, will display dropdown with toolbar buttons. It's upto your logic to show desired options and onchange function. Here 'list1' is assumed to be grid id.</p> <pre><code>&lt;script&gt;\n    jQuery(window).load(function(){\n        jQuery('#list1_pager_left').append ('&lt;div style=\"padding-left: 5px; padding-top:2px; float:left\"&gt;&lt;select&gt;&lt;option&gt;None&lt;/option&gt;&lt;/select&gt;&lt;/div&gt;');\n    });\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-retain-page-number-on-page-refresh","title":"Q) How to retain page number on page refresh?","text":"<p>You can have something like following, to preserve page number.</p> <pre><code>$grid = new jqgrid();\n\nif (isset($_GET[\"jqgrid_page\"]))\n    $_SESSION[\"jqgrid_page\"] = $_GET[\"jqgrid_page\"];\n\n$opt[\"caption\"] = \"Clients Data\";\n$opt[\"page\"] = intval($_SESSION[\"jqgrid_page\"]);\n$grid-&gt;set_options($opt);\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-persist-selection-data-ordering-column-order-page-number-selection-in-grid-expand-same-subgrid-on-page-refresh","title":"Q) How to persist selection, data ordering, column order, page number, selection in grid, expand same subgrid on page refresh?","text":"<p>Include following JS plugins files in your page, and add 'opts' setting before 'echo $out' as mentioned below:</p> <pre><code>&lt;!-- library for persistance storage --&gt;\n&lt;script src=\"//cdn.jsdelivr.net/jstorage/0.1/jstorage.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"//cdn.jsdelivr.net/json2/0.1/json2.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"//cdn.rawgit.com/gridphp/jqGridState/63904a57244ef89fa58ca0fa146da8e2e6e4d395/jqGrid.state.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n\n&lt;script&gt;\nvar opts = {\n    \"stateOptions\": {\n                storageKey: \"gridStateCookie\",\n                columns: true,\n                filters: false,\n                selection: true,\n                expansion: true,\n                pager: true,\n                order: true\n                }\n    };\n&lt;/script&gt;\n\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-keep-page-number-persistence-when-back-button-is-clicked-from-new-page","title":"Q) How to keep page number persistence when back button is clicked from new page?","text":"<p>Here we need some JS trick to pick if back button is clicked. When defining URL in column, here we've placed #moved in url and used JS onclick to send to new page.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Note\";\n$col[\"name\"] = \"note\";\n$col[\"width\"] = \"50\";\n$col[\"editable\"] = true; // this column is editable\n$col[\"default\"] = \"&lt;a href='#moved' onclick=\\\"location.href='details.php'\\\"&gt;Details&lt;/a&gt;\"; // render as select\n$cols[] = $col;\n</code></pre> <p>Enable state persistence of paging, all rest disabled.</p> <pre><code>var opts_list1 = {\n        \"stateOptions\": {\n                    storageKey: \"gridState-list1\",\n                    columns: false, // remember column chooser settings\n                    selection: false, // row selection\n                    expansion: false, // subgrid expansion\n                    filters: false, // filters\n                    pager: true, // page number\n                    order: false // field ordering\n        }\n    };\n</code></pre> <p>And to open first page if not back is clicked, i will clear state persistance if not hash is found in url.</p> <pre><code>&lt;body&gt;\n    &lt;script&gt;\n    jQuery(document).ready(function(){\n        if(window.location.hash==\"\")\n        {\n            jQuery.jStorage.deleteKey('gridState-list1');\n        }\n    });\n    &lt;/script&gt;\n\n    ....\n\n&lt;/body&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-apply-more-advanced-conditional-formatting","title":"Q) How to apply more advanced conditional formatting?","text":"<p>You can set onload event in PHP code, and enable 'reloadedit' option</p> <pre><code>// set js onload event\n$e[\"js_on_load_complete\"] = \"grid_onload\";\n$g-&gt;set_events($e);\n\n// required to format rows after editing\n$opt[\"reloadedit\"] = true;\n...\n$g-&gt;set_options($opt);\n</code></pre> <p>Then in HTML code, you can have custom conditional logic in javascript handler. In this code, list1 is grid id. You can also use php's equivalent '$g-&gt;id' to reference it.</p> <pre><code>&lt;script&gt;\nfunction grid_onload(ids)\n{\n    if(ids.rows)\n        jQuery.each(ids.rows,function(i)\n        {\n            // if col1 = yes and col2 = n/a, format row\n            if (this.col1.toLowerCase() == 'yes' &amp;&amp; this.col2.toLowerCase() == 'n/a')\n            {\n                // highlight row\n                jQuery('#list1 tr.jqgrow:eq('+i+')').css('background-image','inherit').css({'background-color':'#FBEC88', 'color':'red'});\n            }\n\n            // if col3 = 1, format cell. 'aria-describedby=list1_col3' is 'gridid_colname' convention to identify cell.\n            if (parseInt(this.col3) == 1)\n            {\n                // highlight cell\n                jQuery('#list1 tr.jqgrow:eq('+i+')').css('background-image','inherit');\n                jQuery('#list1 tr.jqgrow:eq('+i+') td[aria-describedby=list1_col3]').css('background','inherit').css({'background-color':'#FBEC88', 'color':'red'});\n            }\n        });\n}\n&lt;/script&gt;\n</code></pre> <p>To make non-editable column as gray, e.g. If 'list1' is grid id and 'name' is non-editable column:</p> <pre><code>&lt;script&gt;\nfunction grid_onload(ids)\n{\n    if(ids.rows)\n        jQuery.each(ids.rows,function(i)\n        {\n            // if col3 = 1, format cell. 'aria-describedby=list1_col3' is 'gridid_colname' convention to identify cell.\n            if (jQuery(\"#list1\").getColProp(\"name\").editable == false)\n            {\n                // highlight cell\n                jQuery('#list1 tr.jqgrow:eq('+i+')').css('background-image','inherit');\n                jQuery('#list1 tr.jqgrow:eq('+i+') td[aria-describedby=list1_name]').css('background','inherit').css({ 'color':'gray'});\n            }\n        });\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-make-single-row-selection-keeping-multiselect-option","title":"Q) How to make single row selection, keeping multiselect option?","text":"<p>Following code will enable single selection, in multiselect mode.</p> <p>PHP code config:</p> <pre><code>$opt[\"beforeSelectRow\"] = \"function(rowid, e) { if ( jQuery('#list1').jqGrid('getGridParam','selarrrow') != rowid) jQuery('#list1').jqGrid('resetSelection'); return true; }\";\n$g-&gt;set_options($opt);\n</code></pre> <p>To hide select all checkbox as well, add this css style.</p> <pre><code>input#cb_list1 {\n    display: none;\n}\n</code></pre> <p>where <code>list1</code> is grid id.</p>"},{"location":"grid-appearance-faqs.html#q-how-to-turn-multiselect-on-off-dynamically","title":"Q) How to turn multiselect on / off dynamically?","text":"<p>Following code will enable toggle multiselect via javascript code.</p> <pre><code>&lt;input type=\"button\" value=\"Multiselect\" onclick=\"toggle_multiselect()\"&gt;\n\n&lt;script&gt;\nfunction toggle_multiselect()\n{\n    if ($('#list1 .cbox:visible').length &gt; 0)\n    {\n        $(\"#list1\").jqGrid('setGridParam',{multiboxonly : true});\n        $('#list1').jqGrid('hideCol', 'cb');\n    }\n    else\n    {\n        $(\"#list1\").jqGrid('setGridParam',{multiboxonly : false});\n        $('#list1').jqGrid('showCol', 'cb');\n    }\n}\n&lt;/script&gt;\n</code></pre> <p>where <code>list1</code> is grid id.</p>"},{"location":"grid-appearance-faqs.html#q-how-to-make-select-row-only-by-checkbox","title":"Q) How to make select row only by checkbox?","text":"<p>Following code will enable row selection by checkbox.</p> <pre><code>$opt[\"multiselect\"] = true;\n$opt[\"beforeSelectRow\"] = \"function(rowid, e) { return $(e.target).is('input[type=checkbox]'); }\";\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-increase-font-size-of-grid","title":"Q) How to increase font size of grid?","text":"<p>Following css override will adjust fonts. For any other left area, you can inspect using firebug.</p> <pre><code>&lt;style&gt;\n.ui-jqgrid {\n    font-family: \"tahoma\",\"verdana\",\"sans serif\";\n    font-size: 12px;\n}\n\n.ui-jqgrid .ui-pg-table td {\n    font-size: 12px;\n}\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-stop-reload-grid-after-edit-submit-button","title":"Q) How to stop reload grid after edit submit button?","text":"<p>Following config will stop whole grid reload, and will only update edited row.</p> <pre><code>$grid[\"edit_options\"][\"reloadAfterSubmit\"]=false;\n...\n$g-&gt;set_options($grid);\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-attach-keyboard-shortcuts-with-operations-like-add-search-etc","title":"Q) How to attach Keyboard Shortcuts with operations like Add, Search etc?","text":"<p>You can bind your shortcut keys by adding following lib:</p> <pre><code>&lt;script src=\"//cdn.jsdelivr.net/jquery.hotkeys/0.8b/jquery.hotkeys.js\"&gt;&lt;/script&gt;\n</code></pre> <p>More help on keys are available on its site: http://github.com/tzuryby/hotkeys</p> <p>Next, you will find the ID of button to attach shortcut. Use firebug inspect to hover that button and it would show ID of the element.</p> <p>e.g. To add 'insert' key with '+' button in toolbar</p> <pre><code>&lt;script&gt;\n// insert key to add new row\n$(document).bind('keyup', 'insert', function(){\n      jQuery('#add_list1').click();\n    });\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-increase-overall-grid-toolbar-font-size","title":"Q) How to increase overall Grid &amp; Toolbar font size?","text":"<p>Following on-page styles will increase font-size to 14px (overriding the base css). This inclues grid font, dialogs and toolbar. This will be helpful when using in mobile devices.</p> <pre><code>&lt;style&gt;\n/* increase font &amp; row height */\n.ui-jqgrid *, .ui-widget, .ui-widget input, .ui-widget select, .ui-widget textarea, .ui-widget button { font-size:14px; }\n.ui-jqgrid tr.jqgrow td { height:30px; }\n\n/* big toolbar icons */\n.ui-pager-control .ui-icon, .ui-custom-icon { zoom: 125%; -moz-transform: scale(1.25); -webkit-zoom: 1.25; -ms-zoom: 1.25; }\n.ui-jqgrid .ui-jqgrid-pager .ui-pg-div span.ui-icon { margin: 0px 2px; }\n.ui-jqgrid .ui-jqgrid-pager { height: 28px; }\n.ui-jqgrid .ui-jqgrid-pager .ui-pg-div { line-height: 25px; }\n&lt;/style&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-show-animated-progress-bar-instead-of-text-loading","title":"Q) How to show animated progress bar instead of text 'Loading...'?","text":"<p>You can replace text with some string containing html  tag.</p> <pre><code>$grid[\"loadtext\"] = \"Loading...\";\n$g-&gt;set_options($grid);\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-show-animated-progress-bar-when-submit-data-form","title":"Q) How to show animated progress bar when submit data / form?","text":"<p>You can do it using BlockUI plugin: http://stackoverflow.com/a/22927642/385377</p> <p>Refer integration demo here: Line 46,55 https://gist.github.com/gridphp/915d2e0834354913fdfd338d47d50a53</p>"},{"location":"grid-appearance-faqs.html#q-how-to-make-button-for-next-record-selection-in-grid","title":"Q) How to make button for next record selection in grid ?","text":"<p>Following code will bind JS code with button. where list1 is grid id.</p> <pre><code>&lt;input type=\"button\" value=\"Next\" id=\"btnNext\"&gt;\n\n&lt;script&gt;\n$('#btnNext').click(function () {\n\n    var grid =  $(\"#list1\").jqGrid();\n\n    var selectedRow = grid.getGridParam('selrow');\n    if (selectedRow == null) return;\n\n    var ids = grid.getDataIDs();\n    var index = grid.getInd(selectedRow);\n\n    if (ids.length &lt; 2) return;\n\n    index++;\n    if (index &gt; ids.length)\n        index = 1;\n\n    grid.setSelection(ids[index - 1], true);\n});\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-appearance-faqs.html#q-how-to-focus-on-next-tabindex-of-html-element-onenter-keypress","title":"Q) How to focus on next tabindex of HTML element onEnter keypress?","text":"<p>Following code will enable this 'Enter' key for next tabindex movement. </p> <pre><code>$opt[\"add_options\"][\"afterShowForm\"] = \"function (form) \n{\n    jQuery(form).on('keydown', 'input,select,textarea', function (event) {\n        if (event.key == 'Enter') {\n\n            var fields = 'input:visible, select:visible, textarea:visible';\n\n            // focus next field\n            jQuery(fields,form)[jQuery(fields,form).index(this)+1].focus();\n            if (jQuery(fields,form)[jQuery(fields,form).index(this)+1].select) \n                jQuery(fields,form)[jQuery(fields,form).index(this)+1].select();\n\n            // submit if next field not present\n            if (jQuery(fields,form)[jQuery(fields,form).index(this)+1])\n                window.event.returnValue = false;\n        }\n    });\n\n}\";\n\n$opt[\"edit_options\"][\"afterShowForm\"] = $opt[\"add_options\"][\"afterShowForm\"];\n\n$g-&gt;set_options($opt);\n</code></pre> <p>Another JS based solution is to place following code at end on html.</p> <pre><code>&lt;script type=\"text/javascript\"&gt;\n// Focus Next on Enter\n// https://stackoverflow.com/a/40686327/8743891\n\nfunction focusNextElement() {\n  var focussableElements = 'a:not([disabled]), button:not([disabled]), input[type=text]:not([disabled]), [tabindex]:not([disabled]):not([tabindex=\"-1\"])';\n    var focussable = Array.prototype.filter.call(document.querySelectorAll(focussableElements),\n      function(element) {\n        return element.offsetWidth &gt; 0 || element.offsetHeight &gt; 0 || element === document.activeElement\n      });\n    var index = focussable.indexOf(document.activeElement);\n    focussable[index + 1].focus();\n}\nwindow.addEventListener('keydown', function(e) {\n  if (e.keyIdentifier == 'U+000A' || e.keyIdentifier == 'Enter' || e.keyCode == 13) {\n    if (e.target.nodeName === 'INPUT' &amp;&amp; e.target.type !== 'textarea') {\n        e.preventDefault();\n        focusNextElement();\n        e.stopImmediatePropagation()\n        return false;\n    }\n  }\n}, true);\n&lt;/script&gt;\n</code></pre>"},{"location":"grid-events.html","title":"Grid Events","text":""},{"location":"grid-events.html#grid-events","title":"Grid Events","text":"<p>For advance solutions, We are not limited to single table operations. We often need to update several tables and execute extra business cases like sending an email or soft delete a record.</p> <p>We can have our own code-behind implementation for ADD, UPDATE or DELETE operations.</p> <p>The <code>on_insert</code> takes 3 params (function-name, class-object or null-if-global-func, continue-default-grid-operation)</p> <p>If you pass last argument as true, functions will act as a filter and insert/update in <code>-&gt;table</code> will be performed by grid after your function. If last argument is set to false, only your function handler will be executed and grid's internal implementation will be ignored.</p> <pre><code>$e[\"on_insert\"] = array(\"add_client\", null, false);\n$e[\"on_update\"] = array(\"update_client\", null, false);\n$e[\"on_delete\"] = array(\"delete_client\", null, true);\n\n// return last inserted id for further working\n$e[\"on_after_insert\"] = array(\"after_insert\", null, true);\n$e[\"on_after_update\"] = array(\"after_update\", null, true);\n\n// invoked to filter data before displaying on grid\n$e[\"on_data_display\"] = array(\"filter_display\", null, true);\n\n// ...\n\n$g-&gt;set_events($e);\n</code></pre> <p>In each callbacks, <code>$data</code> is passed to function which contains all posted data. We can <code>print_r()</code> it for further help.</p> <pre><code>function add_client($data)\n{\n    global $grid;\n    $grid-&gt;execute_query(\"INSERT INTO clients\n                    VALUES (null,'{$data[\"params\"][\"name\"]}'\n                                ,'{$data[\"params\"][\"gender\"]}'\n                                ,'{$data[\"params\"][\"company\"]}')\");\n}\n</code></pre> <p>If the 3rd argument is true, the function will behave as a data filter and the final update will be done by grid code. For e.g.</p> <pre><code>$e[\"on_update\"] = array(\"update_client\", null, true);\n...\nfunction update_client(&amp;$data)\n{\n    // set current date time internally\n    $data[\"params\"][\"reg_date\"] = date(\"Y-m-d H:i:s\");\n}\n</code></pre> <p>If the 3rd argument is false, the function will be executed and grid's implementation will be skipped. In that case, the callback for on_insert and on_update should echo JSON, e.g.</p> <pre><code>// if you make it 3rd param to false, then it should return json data\n// e.g. $e[\"on_insert\"] = array(\"add_client\", null, false);\n\nfunction add_client($data)\n{\n    // ... custom code to make $sql\n\n    global $grid; // where $grid = new jqgrid(...);\n\n    $insert_id = $grid-&gt;execute_query($sql,false,\"insert_id\");\n\n    if (intval($insert_id)&gt;0)\n        $res = array(\"id\" =&gt; $insert_id, \"success\" =&gt; true);\n    else\n        $res = array(\"id\" =&gt; 0, \"success\" =&gt; false);\n\n    echo json_encode($res);\n    die;\n}\n</code></pre> <p>Inside callback functions, you can check whether $data variables have all such keys. Following will print $data in error msg. You can debug all data to see the issue.</p> <p>You can also put phpgrid_error(mysql_error()); before die statement.</p> <pre><code>function update_client($data)\n{\n    ob_start();\n    print_r($data);\n    phpgrid_error(ob_get_clean());\n\n    // ...\n}\n</code></pre> <p>You can also write you custom function for data export (see export-custom.php) $e[\"on_export\"] = array(\"do_export\", null);</p> <pre><code>// custom on_export callback function\nfunction custom_export($param)\n{\n    $sql = $param[\"sql\"]; // the SQL statement for export\n    $grid = $param[\"grid\"]; // the complete grid object reference\n\n    if ($grid-&gt;options[\"export\"][\"format\"] == \"xls\")\n    {\n        // excel generate code goes here\n    }\n    else if ($grid-&gt;options[\"export\"][\"format\"] == \"pdf\")\n    {\n        // pdf generate code goes here\n    }\n}\n</code></pre> <p>To use custom SQL for search operations on particular field, you can use on_select event.</p> <pre><code>$e[\"on_select\"] = array(\"custom_select\",\"\");\n$g-&gt;set_events($e);\n\nfunction custom_select($d)\n{\n    // search params\n    $search_str = $this-&gt;strip($d[\"param\"]['filters']);\n    $search_arr = json_decode($search_str,true);\n    $gopr = $search_arr['groupOp'];\n    $rule = $search_arr['rules'][0];\n\n    // sort by params\n    $sidx = $d[\"param\"]['sidx']; // get index row - i.e. user click to sort\n    $sord = $d[\"param\"]['sord']; // get the direction\n\n    if ($rule[\"field\"] == \"name\")\n    {\n        $d[\"sql\"] = \"select * from clients WHERE name like '%{$rule[\"data\"]}%' ORDER BY $sidx $sord\";\n        $d[\"sql_count\"] = \"select count(*) as c from clients\";\n    }\n}\n</code></pre> <p>You can also set Client side event handlers (e.g. on row select)</p> <p>Step1: Set JS event handler</p> <pre><code>// just set the JS function name (should exist)\n$e[\"js_on_select_row\"] = \"do_onselect\";\n...\n$grid-&gt;set_events($e);\n</code></pre> <p>Step2: Define JS event handler (where 'list1' is grid id and 'company' is field name to load)</p> <pre><code>&lt;script&gt;\nfunction do_onselect(id)\n{\n    var rd = jQuery('#list1').jqGrid('getCell', id, 'company'); // where invdate is column name\n    jQuery(\"#span_extra\").html(rd);\n}\n&lt;/script&gt;\n&lt;br&gt;\nCompany: &lt;span id=\"span_extra\"&gt;Not Selected&lt;/span&gt;\n</code></pre>"},{"location":"grid-events.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/editing/custom-events.php</code></li> </ul>"},{"location":"grid-options.html","title":"Grid Settings","text":""},{"location":"grid-options.html#grid-options","title":"Grid Options","text":""},{"location":"grid-options.html#custom-sql-query","title":"Custom SQL Query","text":"<p>By default, when we define the <code>-&gt;table</code> property, it fetches all the possible columns of table. We can provide custom SQL query in <code>-&gt;select_command</code> property to pick columns available for grid. We can use complex multi-join sub-queries in it.</p> <pre><code>$g-&gt;select_command = \"SELECT i.id, invdate , c.name,\n                        i.note, i.total, i.closed FROM invheader i\n                        INNER JOIN clients c ON c.client_id = i.client_id\";\n</code></pre>"},{"location":"grid-options.html#grid-settings","title":"Grid Settings","text":"<p>You can use following options for <code>-&gt;set_options($opt)</code> function.</p>"},{"location":"grid-options.html#records-per-page","title":"Records per Page","text":"<p>Number of records to show on page</p> <pre><code>$opt[\"rowNum\"] = 10;\n</code></pre>"},{"location":"grid-options.html#options-to-show-in-paging-records","title":"Options to show in paging records","text":"<pre><code>$opt[\"rowList\"] = array(10,20,30);\n\n// you can also set 'All' for all records\n$opt[\"rowList\"] = array(10,20,30,'All');\n\n// empty array will hide dropdown\n$opt[\"rowList\"] = array();\n</code></pre>"},{"location":"grid-options.html#show-row-numbers","title":"Show Row numbers","text":"<p>To show row numbers before each records, and set that column's width</p> <pre><code>$opt[\"rownumbers\"] = true;\n$opt[\"rownumWidth\"] = 30;\n</code></pre>"},{"location":"grid-options.html#show-paging-buttons","title":"Show Paging Buttons","text":"<p>To show/remove Paging navigation buttons</p> <pre><code>$opt[\"pgbuttons\"] = false;\n</code></pre>"},{"location":"grid-options.html#set-initial-page","title":"Set Initial Page","text":"<p>To set initial page (e.g. as page 2) of grid</p> <pre><code>$opt[\"page\"] = 2;\n\n// to set last page, set some big number\n$opt[\"page\"] = 9999;\n</code></pre> <p>In order to use direct url of certain page, you can use $_GET. e.g. grid.php?p=2</p> <pre><code>$opt[\"page\"] = $_GET[\"p\"];\n</code></pre>"},{"location":"grid-options.html#show-paging-text","title":"Show Paging text","text":"<p>To show/remove Paging text e.g. Page 1 of 10</p> <pre><code>$opt[\"pgtext\"] = null;\n</code></pre> <p>Enable or Disable total records text on grid</p> <pre><code>$opt[\"viewrecords\"] = true;\n</code></pre>"},{"location":"grid-options.html#fit-columns","title":"Fit Columns","text":"<p>If set to true, and resizing the width of a column, the adjacent column (to the right) will resize so that the overall grid width is maintained (e.g., reducing the width of column 2 by 30px will increase the size of column 3 by 30px). In this case there is no horizontal scrolbar. Note: this option is not compatible with shrinkToFit option - i.e if shrinkToFit is set to false, forceFit is ignored.</p> <pre><code>$opt[\"forceFit\"] = true;\n</code></pre>"},{"location":"grid-options.html#extend-columns-to-grid-width","title":"Extend Columns to Grid Width","text":"<p>This option describes the type of calculation of the initial width of each column against with the width of the grid. If the value is true and the value in width option is set then: Every column width is scaled according to the defined option width.</p> <pre><code>$opt[\"shrinkToFit\"] = true;\n</code></pre>"},{"location":"grid-options.html#column-layout","title":"Column Layout","text":"<p>The autocolumn property split dialog fields in desired column layout. For e.g. for 2 column layout, set:</p> <pre><code>$opt[\"autocolumn\"] = 2;\n</code></pre>"},{"location":"grid-options.html#autowidth","title":"Autowidth","text":"<p>Expand grid to screen width</p> <pre><code>$opt[\"autowidth\"] = true;\n</code></pre>"},{"location":"grid-options.html#resizable-grid","title":"Resizable Grid","text":"<p>Show corner (lower-right) resizable option on grid</p> <pre><code>$opt[\"resizable\"] = true; // defaults to false\n</code></pre>"},{"location":"grid-options.html#responsive-switch","title":"Responsive Switch","text":"<p>Auto resize grid with browser resize</p> <pre><code>$opt[\"autoresize\"] = true; // defaults to false\n</code></pre>"},{"location":"grid-options.html#initially-hidden-grid","title":"Initially Hidden Grid","text":"<p>If set to true the grid initially is hidden. The data is not loaded (no request is sent) and only the caption layer is shown. When the show/hide button is clicked the first time to show grid, the request is sent to the server, the data is loaded, and grid is shown. From this point we have a regular grid. This option has effect only if the caption property is not empty and the hidegrid property (see below) is set to true.</p> <pre><code>$opt[\"hiddengrid\"] = true;\n</code></pre>"},{"location":"grid-options.html#show-hide-grid-button","title":"Show Hide Grid button","text":"<p>Enables or disables the show/hide grid button, which appears on the right side of the Caption layer. Takes effect only if the caption property is not an empty string.</p> <pre><code>$opt[\"hidegrid\"] = true;\n</code></pre>"},{"location":"grid-options.html#grid-height","title":"Grid Height","text":"<p>The height of the grid. Can be set as percentage or any valid measured value</p> <pre><code>// set in pixels\n$opt[\"height\"] = \"400\";\n\n// to remove vertical scroll bar\n$opt[\"height\"] = \"100%\";\n</code></pre> <p>In order to make grid height based on parent container, use following. The <code>list1</code> should be replaced with your grid id.</p> <pre><code>// in grid options\n$opt[\"loadComplete\"] = \"function(){\n    var gid = 'list1';\n    var h_offset = jQuery('.ui-jqgrid-titlebar').outerHeight()\n                            +jQuery('.ui-jqgrid-hdiv').outerHeight()\n                            +jQuery('.ui-jqgrid-toppager').outerHeight()\n                            +jQuery('.ui-jqgrid-pager').outerHeight();\n\n    jQuery('#'+gid).jqGrid('setGridHeight', jQuery('#gbox_'+gid).parent().innerHeight()-h_offset);\n}\";\n</code></pre> <p>The parent container div must have fixed height (static or set dynamically)</p> <pre><code>&lt;div style=\"height:750px\"&gt;\n    &lt;?php echo $out ?&gt;\n&lt;/div&gt;\n</code></pre>"},{"location":"grid-options.html#grid-width","title":"Grid Width","text":"<p>If this option is not set, the width of the grid is a sum of the widths of the columns defined</p> <pre><code>$opt[\"width\"] = \"600\";\n</code></pre>"},{"location":"grid-options.html#loading-text","title":"Loading Text","text":"<p>The text which appear when requesting and sorting data. Defaults to <code>Loading...</code></p> <pre><code>$opt[\"loadtext\"] = \"Loading...\";\n</code></pre>"},{"location":"grid-options.html#toolbar-position","title":"Toolbar Position","text":"<p>This option defines the toolbar of the grid. This is array with two values in which the first value enables the toolbar and the second defines the position relative to body Layer. Possible values \"top\" or \"bottom\" or \"both\"</p> <pre><code>$opt[\"toolbar\"] = \"top\";\n</code></pre>"},{"location":"grid-options.html#multiselect-records","title":"Multiselect Records","text":"<p>Allow you to multi-select through checkboxes</p> <pre><code>$opt[\"multiselect\"] = true;\n</code></pre> <p>Allow you to multi-select through checkboxes and not whole row</p> <pre><code>$opt[\"multiboxonly\"] = true;\n</code></pre> <p>This parameter have sense only multiselect option is set to true. The possible values are: shiftKey, altKey, ctrlKey</p> <pre><code>$opt[\"multikey\"] = true;\n</code></pre>"},{"location":"grid-options.html#alternate-row-color","title":"Alternate Row Color","text":"<p>Set a zebra-striped grid, boolean</p> <pre><code>$opt[\"altRows\"] = true;\n</code></pre>"},{"location":"grid-options.html#initial-grid-sorting","title":"Initial Grid Sorting","text":"<p>Default sort grid by this field, Sort ASC or DESC</p> <pre><code>$opt[\"sortname\"] = 'id';\n$opt[\"sortorder\"] = \"desc\";\n</code></pre> <p>To sort on multiple fields (at time of loading)</p> <pre><code>// Date will be sorted desc, and ID asc.\n$opt[\"sortname\"] = \"date DESC,id\";\n$opt[\"sortorder\"] = \"ASC\";\n</code></pre> <p>To sort first click in DESC sequence, set:</p> <pre><code>$opt[\"firstsortorder\"] = \"desc\";\n</code></pre> <p>This will make SQL: ORDER BY date DESC,id ASC</p>"},{"location":"grid-options.html#grid-multi-column-sorting","title":"Grid Multi-Column Sorting","text":"<p>In case of multi sort when first time clicked the sort is asc (or descending) the next click sort to opposite direction the third click of the column remove the sorting from that column. Your first column must have similar records to see the change of second level sorting and onwards.</p> <pre><code>$opt[\"multiSort\"] = true;\n</code></pre>"},{"location":"grid-options.html#grid-caption","title":"Grid Caption","text":"<p>This will set grid caption.</p> <pre><code>$opt[\"caption\"] = \"Invoice Data\";\n</code></pre> <p>In order to remove caption bar, set it to blank.</p> <pre><code>$opt[\"caption\"] = \"\";\n</code></pre>"},{"location":"grid-options.html#lazy-loading-of-pages","title":"Lazy Loading of Pages","text":"<p>Creates dynamic scrolling grids. When enabled, the pager elements are disabled and we can use the vertical scrollbar to load data. useful for big datasets</p> <pre><code>$opt[\"scroll\"] = true;\n</code></pre>"},{"location":"grid-options.html#rtl-or-ltr","title":"RTL or LTR","text":"<p>Makes grid right to left, for rtl languages e.g. arabic. Default is ltr</p> <pre><code>$opt[\"direction\"] = \"rtl\";\n</code></pre>"},{"location":"grid-options.html#tooltips","title":"Tooltips","text":"<p>Enable tooltips for icons and long text: true/false</p> <pre><code>$opt[\"tooltip\"] = true;\n</code></pre>"},{"location":"grid-options.html#hotkeys","title":"Hotkeys","text":"<p>Enable or disable hotkeys for add, edit or delete operations: true/false It only work for first grid on page.</p> <pre><code>$opt[\"hotkeys\"] = true;\n</code></pre>"},{"location":"grid-options.html#excel-mode-switch","title":"Excel Mode Switch","text":"<p>Inline cell editing, like spreadsheet</p> <pre><code>$opt[\"cellEdit\"] = true;\n</code></pre>"},{"location":"grid-options.html#reload-after-edit","title":"Reload after Edit","text":"<p>To reload whole grid after editing</p> <pre><code>$opt[\"reloadedit\"] = true;\n</code></pre>"},{"location":"grid-options.html#display-pager-on-top","title":"Display Pager on Top","text":"<p>Display Top Pager bar</p> <pre><code>$opt[\"toppager\"] = true;\n</code></pre>"},{"location":"grid-options.html#url-for-ajax-calls","title":"URL for Ajax calls","text":"<p>URL for grid page (for ajax calls), defaults to REQUEST_URI. It works with http &amp; https. Used when passing extra querystring data, e.g.</p> <pre><code>$opt[\"url\"] = \"http://domain/page.php?test=1\";\n</code></pre>"},{"location":"grid-options.html#grid-dialog-customizations","title":"Grid Dialog Customizations","text":"<p>Set Add and Edit form &amp; View dialog width. This can be used with combination of css customization of dialog forms.</p> <pre><code>$opt[\"add_options\"] = array('width'=&gt;'420');\n$opt[\"edit_options\"] = array('width'=&gt;'420');\n$opt[\"view_options\"] = array('width'=&gt;'420');\n</code></pre> <p>Just like width in dialog options, you can also set other for e.g.</p> <pre><code>$opt[\"add_options\"] = array('width'=&gt;'420',\n                            \"closeAfterAdd\"=&gt;true, // close dialog after add/edit\n                            \"clearAfterAdd\"=&gt;true, // clear fields after add/edit - default true\n                            \"top\"=&gt;\"200\", // absolute top position of dialog\n                            \"left\"=&gt;\"200\" // absolute left position of dialog\n                            );\n\n$opt[\"edit_options\"] = array('width'=&gt;'420',\n                            \"closeAfterEdit\"=&gt;true, // close dialog after add/edit\n                            \"top\"=&gt;\"200\", // absolute top position of dialog\n                            \"left\"=&gt;\"200\" // absolute left position of dialog\n                            );\n</code></pre> <p>To specify exact top/left position (as above), you need to set:</p> <pre><code>$opt[\"form\"][\"position\"] = \"\";\n$opt[\"add_options\"][\"jqModal\"] = true;\n</code></pre> <p>On small screen devices when any column is hidden due to responsive behavior, by default a column with \"...\" text is added which opens view dialog showing all columns. To disable it you can set:</p> <pre><code>$opt[\"view_options\"][\"rowButton\"] = false;\n</code></pre>"},{"location":"grid-options.html#dialog-title-customization","title":"Dialog Title Customization","text":"<p>To change the title of Add Dialog   </p> <pre><code>$opt[\"add_options\"][\"addCaption\"] = \"Add Customer\";\n</code></pre> <p>To change the title of Edit Dialog  </p> <pre><code>$opt[\"edit_options\"][\"editCaption\"] = \"Edit Customer\";\n</code></pre> <p>To change the title of View Dialog  </p> <pre><code>$opt[\"view_options\"][\"caption\"] = \"View Customer\";\n</code></pre>"},{"location":"grid-options.html#dialog-success-message","title":"Dialog Success Message","text":"<p>You can also customize the success messages that appear after add/edit/del operations.</p> <pre><code>$opt[\"add_options\"][\"success_msg\"] = \"Post added\";\n$opt[\"edit_options\"][\"success_msg\"] = \"Post updated\";\n$opt[\"delete_options\"][\"success_msg\"] = \"Post deleted\";\n\n// for bulk editing\n$opt[\"edit_options\"][\"success_msg_bulk\"] = \"Post(s) updated\";\n...\n$g-&gt;set_options($opt);\n</code></pre> <p>To remove these success messages, you can set:</p> <pre><code>$opt[\"add_options\"][\"afterSubmit\"] = 'function(response) { return [true,\"\"]; }';\n$opt[\"edit_options\"][\"afterSubmit\"] = 'function(response) { return [true,\"\"]; }';\n$opt[\"delete_options\"][\"afterSubmit\"] = 'function(response) { return [true,\"\"]; }';\n</code></pre>"},{"location":"grid-options.html#dialog-submit-confirmation","title":"Dialog Submit Confirmation","text":"<p>This option work only in editing mode. If Set to true this option will work only when a submit button is clicked and if any data is changed in the form. If the data is changed a dilog message appear where the user is asked to confirm the changes or cancel it.</p> <pre><code>$opt[\"edit_options\"][\"checkOnSubmit\"] = true;\n</code></pre>"},{"location":"grid-options.html#dialog-display-position","title":"Dialog Display Position","text":"<p>To Set Form to position on center of screen</p> <pre><code>$opt[\"form\"][\"position\"] = \"center\";\n</code></pre>"},{"location":"grid-options.html#show-dialog-navigation-buttons","title":"Show Dialog Navigation buttons","text":"<p>Enable form Prev | Next record navigation</p> <pre><code>$opt[\"form\"][\"nav\"] = true;\n</code></pre> <p>Refer demos/appearance/dialog-layout.php for demo.</p>"},{"location":"grid-options.html#row-action-icons-or-text","title":"Row Action Icons or Text","text":"<p>You can enable / disable the row action icons, by setting it true or false. It is enabled by default in latest version.</p> <pre><code>$opt[\"actionicon\"] = false;\n...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"grid-options.html#global-column-setting","title":"Global Column Setting","text":"<p>If we want to set some column property across all columns of grid, without individually setting them with column definition, We can use <code>cmTemplate</code> property.</p> <pre><code>$opt[\"shrinkToFit\"] = false;\n$opt[\"autowidth\"] = true;\n$opt[\"cmTemplate\"] = array(\"width\"=&gt;\"400\");\n...\n$g-&gt;set_options($opt);\n</code></pre> <p>Above will set each column width to 400.</p>"},{"location":"grid-options.html#grid-actions","title":"Grid Actions","text":"<p>We can also switch actions to enable or disable them on grid. It is controlled by <code>-&gt;set_actions()</code> function.</p> <p>Possible values are <code>true</code> or <code>false</code>.</p> Operations Description <code>add</code> Enable / Disable add operation on grid. Defaults to <code>true</code>. <code>edit</code> Enable / Disable edit operation on grid. Defaults to <code>true</code>. <code>bulkedit</code> Enable / Disable bulk edit operation on grid. Defaults to <code>false</code>. <code>delete</code> Enable / Disable delete operation on grid. Defaults to <code>true</code>. <code>view</code> Enable / Disable view operation on grid. Defaults to <code>true</code>. <code>clone</code> Enable / Disable clone operation on grid. Defaults to <code>false</code>. <code>rowactions</code> Enable / Disable inline edit/del/save option. Defaults to <code>true</code>. <code>export</code> Enable / Disable export to excel option. Defaults to <code>false</code>. <code>import</code> Enable / Disable import data option. Defaults to <code>false</code>. <code>autofilter</code> Enable / Disable autofilter toolbar for search on top. Defaults to <code>true</code>. <code>showhidecolumns</code> Enable / Disable button to hide certain columns from client side. Defaults to <code>true</code>. <code>inlineadd</code> Enable / Disable button to perform insertion inline. Defaults to <code>false</code>. <code>search</code> Search property can have 3 values, <code>simple</code>, <code>advance</code> or <code>false</code> to hide. <p>Code:</p> <pre><code>$g-&gt;set_actions(array(\n                        \"add\"=&gt;true,\n                        \"edit\"=&gt;true,\n                        \"clone\"=&gt;true,\n                        \"bulkedit\"=&gt;true,\n                        \"delete\"=&gt;true,\n                        \"view\"=&gt;true,\n                        \"rowactions\"=&gt;true,\n                        \"export\"=&gt;true,\n                        \"import\"=&gt;true,\n                        \"autofilter\" =&gt; true,\n                        \"search\" =&gt; \"simple\",\n                        \"inlineadd\" =&gt; true,\n                        \"showhidecolumns\" =&gt; true\n                    )\n                );\n</code></pre>"},{"location":"grouping-headers.html","title":"Grouping Headers","text":""},{"location":"grouping-headers.html#grouping-headers","title":"Grouping Headers","text":"<p>Now you can have a grouped headers in gridphp control. It would help in categorizing your related columns. (demos/appearance/group-header.php)</p> <pre><code>// group columns header\n$g-&gt;set_group_header( array(\n                            \"useColSpanStyle\"=&gt;true,\n                            \"groupHeaders\"=&gt;array(\n                                array(\n                                    \"startColumnName\"=&gt;'name', // group starts from this column\n                                    \"numberOfColumns\"=&gt;2, // group span to next 2 columns\n                                    \"titleText\"=&gt;'Personal Information' // caption of group header\n                                ),\n                                array(\n                                    \"startColumnName\"=&gt;'company', // group starts from this column\n                                    \"numberOfColumns\"=&gt;2, // group span to next 2 columns\n                                    \"titleText\"=&gt;'Company Details' // caption of group header\n                                )\n                            )\n                        )\n                    );\n</code></pre>"},{"location":"grouping-headers.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/group-headers.php</code></li> </ul>"},{"location":"grouping.html","title":"Grouping Columns","text":""},{"location":"grouping.html#grouping","title":"Grouping","text":"<p>Following setting will enable grouping footer in grid. (see grouping.php)</p> <pre><code>$opt[\"grouping\"] = true;\n$opt[\"groupingView\"] = array();\n\n// specify column name to group listing\n$opt[\"groupingView\"][\"groupField\"] = array(\"gender\");\n\n// either show grouped column in list or not (default: true)\n$opt[\"groupingView\"][\"groupColumnShow\"] = array(false);\n\n// {0} is grouped value, {1} is count in group\n$opt[\"groupingView\"][\"groupText\"] = array(\"&lt;b&gt;{0} - {1} Item(s)&lt;/b&gt;\");\n\n// show group in asc or desc order\n$opt[\"groupingView\"][\"groupOrder\"] = array(\"asc\");\n\n// show sorted data within group\n$opt[\"groupingView\"][\"groupDataSorted\"] = array(true);\n\n// work with summaryType, summaryTpl, see column: $col[\"name\"] = \"total\";\n$opt[\"groupingView\"][\"groupSummary\"] = array(true);\n\n// Turn true to show group collapse (default: false)\n$opt[\"groupingView\"][\"groupCollapse\"] = false;\n\n// show summary row even if group collapsed (hide)\n$opt[\"groupingView\"][\"showSummaryOnHide\"] = true;\n\n// by default grouping titles are case sensitive. To combine multiple records in same group, set:\n$opt[\"groupingView\"][\"isInTheSameGroup\"] = array(\n        \"function (x, y) { return String(x).toLowerCase() === String(y).toLowerCase(); }\"\n    );\n$opt[\"groupingView\"][\"formatDisplayField\"] = array(\n        \"function (displayValue, cm, index, grp) { return displayValue[0].toUpperCase() + displayValue.substring(1).toLowerCase(); }\"\n    );\n</code></pre>"},{"location":"grouping.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/grouping.php</code></li> </ul>"},{"location":"html-editor.html","title":"HTML Editor","text":""},{"location":"html-editor.html#html-editor","title":"HTML Editor","text":"<p>Step1: Include JS / CSS files required to have this feature. Make sure you include JS files after jQuery JS inclusion.</p> <pre><code>&lt;script src=\"https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js\"&gt;&lt;/script&gt;\n</code></pre> <p>Step2:</p> <p>To have html editor in edit mode, add following properties with desired column:</p> <pre><code>$col[\"edittype\"] = \"textarea\"; \n$col[\"formatter\"] = \"html\";\n$col[\"editoptions\"][\"dataInit\"] = \"function(el){ setTimeout(function(){ link_tinymce(el); },200); }\";\n</code></pre> <p>Add following JS callback function that will connect html editor with your textarea:</p> <pre><code>&lt;script type=\"text/javascript\"&gt;\nfunction link_tinymce(el)\n{\n    // remove nbsp; from start of textarea\n    if(el.previousSibling) el.parentNode.removeChild(el.previousSibling);\n    $(el).parent().css('padding-left','6px');\n\n    // connect tinymce, for options visit http://www.tinymce.com/wiki.php\n    try {\n    tinymce.remove(\"textarea#\"+jQuery(el).attr('id'));\n    } catch(ex) {}\n\n    tinymce.init({\n        selector: \"textarea#\"+jQuery(el).attr('id'),\n        menubar: false,\n        forced_root_block : \"\", \n        force_br_newlines : true, \n        force_p_newlines : false,\n        plugins: [\n            \"advlist autolink lists link image charmap print preview anchor\",\n            \"searchreplace visualblocks code fullscreen\",\n            \"insertdatetime media table contextmenu paste\"\n        ],\n        toolbar: \"insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image\"\n    });\n\n    // fix to focus typing\n    jQuery(document).unbind('keypress').unbind('keydown');\n\n    // bind onchange with textarea\n    var ed = tinymce.activeEditor;\n    ed.on('change', function (e) {\n        jQuery(el).val(ed.getBody().innerHTML);\n    });\n\n}\n&lt;/script&gt;\n</code></pre>"},{"location":"importing-data.html","title":"Importing Data","text":""},{"location":"importing-data.html#importing-data","title":"Importing Data","text":"<p>Import data option can be enabled by setting <code>import</code> to <code>true</code> in set_actions, as mentioned below:</p> <pre><code>$g-&gt;set_actions(array(\n                        \"add\"=&gt;true,\n                        \"edit\"=&gt;true,\n                        \"delete\"=&gt;true,\n                        \"import\"=&gt;true,\n                        \"search\" =&gt; \"advance\"\n                    )\n                );\n</code></pre> <p>Step1: Select File / Copy-Paste data from Excel</p> <p></p> <p>Step2: Map imported data on Database fields</p> <p></p> <p>Step3: Finished</p> <p></p> <p>By default new rows are appended. If you want to show append or replace option on Step2, you can set:</p> <pre><code>$opt[\"import\"][\"allowreplace\"] = true;\n$g-&gt;set_options($opt);\n</code></pre> <p>If you want to adjust CSV headers and database fields mapping accuracy percentage, default: 80:</p> <pre><code>$opt[\"import\"][\"match\"] = 95;\n$g-&gt;set_options($opt);\n</code></pre> <p>If you wish to remove certain database fields in import mapping, e.g.</p> <pre><code>$opt[\"import\"][\"hidefields\"] = array(\"client_id\");\n$g-&gt;set_options($opt);\n</code></pre> <p>To show import dialog on startup, set this code in loadComplete event. Here list1 is grid id.</p> <pre><code>$opt[\"loadComplete\"] = \"function(){ \n                                    if(!jQuery.data(document,'runonce')) \n                                    { \n                                        jQuery.data(document,'runonce',true); \n                                        $('td#import_list1').click(); \n                                    } \n                                }\";\n</code></pre>"},{"location":"importing-data.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/export/import.php</code></li> </ul>"},{"location":"inline-charts.html","title":"Inline charts","text":""},{"location":"inline-charts.html#inline-charts","title":"Inline Charts","text":""},{"location":"javascript-api-faqs.html","title":"Javascript API FAQs","text":""},{"location":"javascript-api-faqs.html#javascript-api-faqs","title":"Javascript API FAQs","text":""},{"location":"javascript-api-faqs.html#q-how-can-i-get-ids-or-data-of-the-selected-rows-of-grid","title":"Q) How can i get IDs or Data of the selected rows of grid?","text":"<p>On client side, you can have ids in this way, where \"list1\" is grid identifier.</p> <p>Returns null if no row is selected  (single row)</p> <pre><code>var selr = jQuery('#list1').jqGrid('getGridParam','selrow');\n</code></pre> <p>Return array of id's of the selected rows when multiselect options is true. Empty array if not selection</p> <pre><code>var selr = jQuery('#list1').jqGrid('getGridParam','selarrrow');\n</code></pre> <p>Return data of passed row and col, where invdate is column name</p> <pre><code>var rd = jQuery('#list1').jqGrid('getCell', selr, 'invdate');\n</code></pre> <p>To get all ids</p> <pre><code>var rows = $('#list1').jqGrid('getDataIDs');\n</code></pre> <p>Get particular column data, returns array</p> <pre><code>var data = $('#list1').jqGrid('getCol', 'total');\n</code></pre> <p>Get particular column properties, returns array</p> <pre><code>var prop = $('#list1').jqGrid('getColProp', 'total');\nalert(prop.editrules.required);\n</code></pre> <p>Set particular column properties</p> <pre><code>$('#list1').jqGrid('setColProp', 'total', {editrules: {required:true} });\n</code></pre> <p>To select / unselect grid row, e.g. rowid 5</p> <pre><code>jQuery('#list1').jqGrid('setSelection', 5, true);\n</code></pre> <p>To reset grid selections</p> <pre><code>jQuery('#list1').jqGrid('resetSelection');\n</code></pre> <p>To hide/show grid columns (e.g.invdate)</p> <pre><code>jQuery('#list1').jqGrid('hideCol','invdate');\njQuery('#list1').jqGrid('showCol','invdate');\n</code></pre> <p>To select all grid rows</p> <pre><code>jQuery('#list1').jqGrid('resetSelection');\nvar ids = jQuery('#list1').jqGrid('getDataIDs');\nfor (i = 0; i &lt; ids.length; i++) {\n    jQuery('#list1').jqGrid('setSelection', ids[i], true);\n}\n</code></pre> <p>You get all row data for rowid '3'</p> <pre><code>var row =  $('#list1').getRowData(3);\n\n// Sample row data output is:\n{invid:\"1\", invdate:\"2007-10-01\", note:\"note\", amount:\"200.00\", tax:\"10.00\", total:\"210.00\"};\n</code></pre> <p>To get all data in 2d array, call getRowData without param.</p> <pre><code>var rows =  $('#list1').getRowData();\n</code></pre> <p>To get current search filter</p> <pre><code>// will give you a string like: \"{\"groupOp\":\"AND\",\"rules\":[{\"field\":\"Name\",\"op\":\"bw\",\"data\":\"a\"}]}\"\nvar filters = $('#list1').getGridParam(\"postData\").filters;\n</code></pre> <p>To get all column titles</p> <pre><code>// returns array with col titles [\"Client Id\", \"Name\", \"Gender\", \"Company\", \"Actions\"]\nvar colNames = jQuery(\"#list1\").jqGrid(\"getGridParam\", \"colNames\");\n</code></pre> <p>To get all column details</p> <pre><code>// returns array with complete column object, use firebug console.log(colModel); for details.\nvar colModel = jQuery(\"#list1\").jqGrid(\"getGridParam\", \"colModel\");\n</code></pre> <p>To get total grid records</p> <pre><code>// returns total records without paging\nvar count = jQuery(\"#list1\").getGridParam(\"records\")\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-bind-javascript-events-with-controls-eg-textbox","title":"Q) How to bind Javascript events with controls e.g. textbox?","text":"<p>You can set them using editoptions</p> <pre><code>$col = array();\n$col[\"title\"] = \"Name\"; // caption of column\n...\n$col[\"editoptions\"] = array(\"onkeyup\"=&gt;\"this.value=this.value.toUpperCase()\");\n$cols[] = $col;\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-reloadrefresh-grid-using-javascript-code-eg-button-click","title":"Q) How to reload/refresh grid using javascript code (e.g. button click)?","text":"<p>You can call this JS code to reload grid. (where 'list1' is grid identifier)</p> <pre><code>jQuery('#list1').trigger(\"reloadGrid\",[{page:1}]);\n</code></pre> <p>To preserve page number on refresh, you \"current\" config.</p> <pre><code>$(\"#list1\").trigger(\"reloadGrid\", [{current:true}]);\n</code></pre> <p>If you wish to auto reload grid at e.g. 2 min interval, you can call this JS code.</p> <pre><code>setInterval(\"jQuery('#list1').trigger('reloadGrid',[{page:1}]);\",2000);\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-use-auto-filter-in-grid-along-with-sorting-on-some-field","title":"Q) How to use auto-filter in grid along with sorting on some field?","text":"<p>Refer this sample config code. This will read the autofilter first field and if it's phone then sort grid descending based on field country, where list1 is grid id.</p> <pre><code>$opt[\"autofilter_options\"][\"beforeSearch\"] = \"function(){\n    var grid = jQuery('#list1');\n    var postData = grid.jqGrid('getGridParam','postData');\n    var searchData = jQuery.parseJSON(postData.filters);\n\n    if (typeof(searchData.rules[0]) != 'undefined' &amp;&amp; searchData.rules[0].field == 'phone')\n        grid.jqGrid('setGridParam',{sortname: 'country', sortorder: 'desc'});\n}\";\n\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-call-custom-javascript-function-on-addeditdel-button-click","title":"Q) How to call custom javascript function on Add/Edit/Del button click?","text":"<p>For instance, if you need custom edit button, You can remove default edit button by following config.</p> <pre><code>$g-&gt;set_actions(array(\n                        \"add\"=&gt;false, // allow/disallow add\n                        \"edit\"=&gt;false, // allow/disallow edit\n                        \"delete\"=&gt;true, // allow/disallow delete\n                        \"rowactions\"=&gt;true, // show/hide row wise edit/del/save option\n                        \"export\"=&gt;true, // show/hide export to excel option\n                        \"autofilter\" =&gt; true, // show/hide autofilter for search\n                        \"search\" =&gt; \"advance\" // show single/multi field search condition (e.g. simple or advance)\n                    )\n                );\n</code></pre> <p>And add your custom button using this JS (where list1 is grid id). You can also reference grid id with <code>$g-&gt;id</code> (where $g = new jqgrid();). This also works with subgrid.</p> <pre><code>&lt;script type=\"text/javascript\"&gt;\n/*\n    CUSTOM TOOLBAR BUTTON\n    ---------------------\n    caption: (string) the caption of the button, can be a empty string.\n    buttonicon: (string) is the ui icon name from UI theme icon set. If this option is set to 'none' only the text appear.\n    onClickButton: (function) action to be performed when a button is clicked. Default null.\n    position: ('first' or 'last') the position where the button will be added (i.e., before or after the standard buttons).\n    title: (string) a tooltip for the button.\n    cursor : string (default pointer) determines the cursor when we mouseover the element\n    id : string (optional) - if set defines the id of the button (actually the id of TD element) for future manipulation\n*/\njQuery(document).ready(function(){\n    jQuery('#list1').jqGrid('navButtonAdd', '#list1_pager',\n    {\n        'caption'      : '',\n        'buttonicon'   : 'ui-icon-pencil',\n        'onClickButton': function()\n        {\n            // your custom JS code ...\n            redireciona();\n            function redireciona() {window.location=\"cadastrar.php\";}\n        },\n        'position': 'first'\n    });\n});\n&lt;/script&gt;\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-post-data-using-js-code","title":"Q) How to post data using JS code?","text":"<p>Assuming, you are posting to grid with id (list1), here is the sample JS code. \"id\" is PK (_empty), \"oper\" will be \"add\" for new record. Rest are the table fields in myData.</p> <pre><code>&lt;script&gt;\n    auto_add = function ()\n    {\n        myData = {};\n        myData.id = \"_empty\";\n        myData.oper = 'add';\n        myData.invdate = '2013-06-12';\n        myData.note = 'test2';\n        myData.total = '22';\n        myData.client_id = '10';\n        jQuery.ajax({\n            url: \"?grid_id=list1\",\n            dataType: \"json\",\n            data: myData,\n            type: \"POST\",\n            error: function(res, status) {\n                alert(res.status+\" : \"+res.statusText+\". Status: \"+status);\n            },\n            success: function( data ) {\n            }\n        });\n        jQuery(\"#list1\").jqGrid().trigger('reloadGrid',[{page:1}]);\n    }\n&lt;/script&gt;\n\n&lt;button onclick=\"auto_add()\"&gt;Add&lt;/button&gt;\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-we-set-grid-caption-using-javascript-code","title":"Q) How to we set grid caption using javascript code?","text":"<p>You can use setCaption method to set new caption on the grid:</p> <pre><code>var grid = $('#myjqgrid');\ngrid.jqGrid('setCaption', 'newCaption');\n</code></pre>"},{"location":"javascript-api-faqs.html#q-how-to-remove-sorting-filters-on-reload","title":"Q) How to remove sorting &amp; filters on reload?","text":"<p>Step1: Remove default refresh button from toolbar.</p> <pre><code>$g-&gt;set_actions(array(\n                        // ...\n                        \"refresh\"=&gt;false, // show/hide export to excel option\n                        // ...\n                    )\n                )\n</code></pre> <p>Step2: Add custom toolbar button using javascript, with refresh data code.</p> <pre><code>jQuery(document).ready(function(){\n\n    jQuery('#list1').jqGrid('navButtonAdd', '#list1_pager',\n    {\n        'caption'      : 'Reload',\n        'buttonicon'   : 'ui-icon-refresh',\n        'onClickButton': function()\n        {\n            var myGrid = jQuery(\"#list1\");\n            jQuery(\"span.s-ico\",myGrid[0].grid.hDiv).hide(); // hide sort icons\n\n            // reset filters and sort field\n            myGrid.setGridParam({\n                        postData: { filters: JSON.stringify({groupOp: \"AND\", rules:[]}) }, sortname: ''\n                    }).trigger('reloadGrid');\n\n            // empty toolbar fields\n            jQuery(\".ui-search-input input\").val(\"\");\n\n        },\n        'position': 'last'\n    });\n});\n\nOR, if we want to persist search filter on refresh\n\njQuery(document).ready(function(){\n    jQuery('#list1').jqGrid('navButtonAdd', '#list1_pager',\n    {\n        'caption'      : '',\n        'buttonicon'   : 'ui-icon-refresh',\n        'onClickButton': function()\n        {\n            var myGrid = jQuery(\"#list1\");\n            var filters = myGrid.getGridParam(\"postData\").filters;\n            // reset filters and sort field\n            myGrid.setGridParam({\n                        postData: { 'filters': filters }, sortname: ''\n                    }).trigger('reloadGrid');\n        },\n        'position': 'last'\n    });\n});\n</code></pre>"},{"location":"laravel-integration.html","title":"Laravel Integration","text":""},{"location":"laravel-integration.html#laravel-integration","title":"Laravel Integration","text":"<p>Following is the guide to integrate PHP Editable DataGrid with Laravel v12.</p>"},{"location":"laravel-integration.html#step-1-folder-placements-in-laravel","title":"Step 1: Folder placements in Laravel.","text":"<p>There are 2 main folders in Grid 4 PHP Framework package archive. You need to:</p> <ul> <li>Copy the contents of lib/inc folder \u2014&gt; /app/Classes/Gridphp <li>Copy the contents of lib/js folder \u2014&gt; /public/assets/gridphp <p></p> <p>The <code>app/Classes</code> folder does not exist by default in Laravel. You may create it for 3rd party class libraries. Create another folder inside it with name <code>Gridphp</code> and move all contents of <code>lib/inc</code> in it. Final result will look like this:</p> <p></p> <p>In similar way, copy the files from lib/js to laravel/public/assets/gridphp. Final result should look like following:</p> <p></p>"},{"location":"laravel-integration.html#step-2-setting-up-factory-class-controller","title":"Step 2: Setting Up Factory Class &amp; Controller:","text":"<p>To use datagrid object in controller, we have setup a factory class in <code>laravel/app/Gridphp.php</code>. The purpose of this class is to:</p> <ul> <li>Set the database configuration.</li> <li>Autoload the library files</li> <li>Provide a get() method to be used in controller.</li> </ul> <p>Now in controller, we used the namespace of our factory class and called the get() function to get the datagrid object. The rest code is same as in our demos. Finally, we passed the output of render() function to view with a variable name 'grid'.</p> <p>For demo purpose, we've modified <code>laravel/app/Http/Controllers/WelcomeController.php</code></p> <p>Note: The DataGrid does not rely on Eloquent ORM model of Laravel. It uses its own data access libraries.</p>"},{"location":"laravel-integration.html#step-3-setting-view-code","title":"Step 3: Setting View code:","text":"<ul> <li>In view code, we included the JS/CSS files from the <code>js</code> folder which we copied in Step 1.1</li> <li>And using blade template variable output, we pushed the grid output in our desired place in html.</li> <li>We have html meta tag for <code>csrf-token</code>, which is required by laravel for POST operations. Also added JavaScript code to pass CSRF-TOKEN in ajax request calls,\u00a0as mentioned in Laravel docs.</li> </ul> <p>For demo purpose, we slightly modified <code>laravel/resources/views/welcome.blade.php</code></p>"},{"location":"laravel-integration.html#step-4-setting-routes","title":"Step 4: Setting Routes","text":"<p>The Last step in this tutorial is to set the routes to our controller. We will use both GET and POST routes as our grid uses both methods.</p>"},{"location":"laravel-integration.html#result","title":"Result","text":"<p>The\u00a0Editable DataGrid for Laravel!</p> <p></p>"},{"location":"localization.html","title":"Localization","text":""},{"location":"localization.html#localization","title":"Localization","text":"<p>To enable text labels in your desired language, change source of the local javascript file. Available language packs are stored in this folder <code>js/jqgrid/js/i18n/</code>. Over 39 language packs are in the solution. (see localization.php)</p> <pre><code>&lt;!-- to enable arabic --&gt;\n&lt;script src=\"js/jqgrid/js/i18n/grid.locale-ar.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n\n&lt;!-- to enable spanish --&gt;\n&lt;script src=\"js/jqgrid/js/i18n/grid.locale-es.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n\n&lt;!-- to enable french --&gt;\n&lt;script src=\"js/jqgrid/js/i18n/grid.locale-fr.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n\n&lt;!-- to enable italian --&gt;\n&lt;script src=\"js/jqgrid/js/i18n/grid.locale-it.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre>"},{"location":"localization.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/misc/localization.php</code></li> </ul> <p>To change string constants, you can edit related lang file e.g. \"lib/js/jqgrid/js/i18n/grid.locale-en.js\" OR do JS override on page:</p> <pre><code>&lt;script&gt;\n$.jgrid.edit.bSubmit = \"Save\";\n&lt;/script&gt;\n</code></pre> <p>To change submit button text for add/edit dialog,</p> <pre><code>$opt[\"add_options\"][\"bSubmit\"] = \"Add\";\n$opt[\"edit_options\"][\"bSubmit\"] = \"Update\";\n// ...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"master-detail-faqs.html","title":"Master Detail FAQs","text":""},{"location":"master-detail-faqs.html#master-detail-faqs","title":"Master Detail FAQs","text":""},{"location":"master-detail-faqs.html#q-how-to-dynamically-change-detail-grids-dropdown-field-content-based-on-selection-of-master-grid-row","title":"Q) How to dynamically change detail grid's dropdown field content, based on selection of master grid row?","text":"<p>Step1: In master-detail.php, we added a dropdown in detail grid, with daraUrl param set to a php page.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Client\";\n$col[\"name\"] = \"client_id\";\n$col[\"width\"] = \"100\";\n$col[\"align\"] = \"left\";\n$col[\"search\"] = true;\n$col[\"editable\"] = true;\n$col[\"edittype\"] = \"select\"; // render as select\n$col[\"editoptions\"] = array(\"dataUrl\"=&gt;\"http://jqgrid/dev/build-select.php\");\n$cols[] = $col;\n</code></pre> <p>Put build-select.php in some web access path, and set correct http url. and, we also set the master grid selection id into session variable.</p> <pre><code>$id = intval($_GET[\"rowid\"]);\nif ($id &gt; 0)\n    $_SESSION[\"rowid\"] = $_GET[\"rowid\"];\n</code></pre> <p>Step2: In build-select.php, we read the session variable and show the dropdown select based on that variable data.</p> <pre><code>&lt;?\nif (!isset($_SESSION) || !is_array($_SESSION))\n    session_start();\n\nif ($_SESSION[\"rowid\"] == \"1\") {\n?&gt;\n    &lt;select&gt;\n    &lt;option value='1'&gt;One&lt;/option&gt;\n    &lt;option value='2'&gt;Two&lt;/option&gt;\n    &lt;/select&gt;\n&lt;?\n}\nelse {\n?&gt;\n    &lt;select&gt;\n    &lt;option value='3'&gt;Three&lt;/option&gt;\n    &lt;option value='4'&gt;Four&lt;/option&gt;\n    &lt;/select&gt;\n&lt;?\n}\n</code></pre> <p>For cascaded dropdown, Following config will be required.</p> <p>On change this column ($col), it will run sql and search it's data on particular field (<code>search_on</code>), then update another dropdown specified in <code>update_field</code>.</p> <pre><code>$col[\"editoptions\"] = array(\n            \"value\"=&gt;$str,\n            \"onchange\" =&gt; array(    \"sql\"=&gt;\"select note as k, note as v from invheader\",\n                                    \"search_on\"=&gt;\"client_id\",\n                                    \"update_field\" =&gt; \"note\" )\n                            );\n</code></pre>"},{"location":"master-detail-faqs.html#q-how-to-load-grid-with-table-that-have-fields-with-spaces","title":"Q) How to load grid with table that have fields with spaces?","text":"<p>You will need to alias the spaced fields with '-' and set query in select_command. e.g.</p> <pre><code>$g-&gt;select_command = \"SELECT `i d` as `i-d`, `client id` AS `client-id`, `inv date` AS `inv-date` FROM invheader\";\n</code></pre> <p>Rest functionality (add/update/del/search) will be handled by library.</p>"},{"location":"master-detail-faqs.html#q-how-to-use-table-with-composite-keys-index","title":"Q) How to use table with composite keys index?","text":"<p>For composite keys - there are two possible approaches:</p> <p>1) Creating a new AUTO_INCREMENT column directly in the database, so that each row has a unique id, then using this column for primary key. You can hide the column using hidden =&gt; true.</p> <p>2) In your SELECT statement (select_command), you may try to select a first column as special concat value that is based on composite keys. This will handle the listings. For insert/update/delete, you will need to use custom events on_update/on_insert/on_delete to parse the new concat field and perform desired operation. Refer demos/editing/custom-events.php for help.</p> <pre><code>// example code 1\n\n$g-&gt;select_command = \"SELECT concat(pk1,'-',pk2) as pk, col2, col3 FROM table\";\n\n$e[\"on_insert\"] = array(\"add_client\", null, true);\n$g-&gt;set_events($e);\n\nfunction add_client($data)\n{\n    $pk = $data[\"params\"][\"pk\"];\n    list(pk1, pk2) = explode(\"-\",$pk);\n\n    $data[\"params\"][\"pk1\"] = $pk1; // setting $data will make sure it will be there in INSERT SQL\n    $data[\"params\"][\"pk2\"] = $pk2;\n}\n\n// example code 2\n\n// Step1: Select concatenated PK with combined composite key\n$g-&gt;select_command = \"SELECT concat(Year_No,'-',Order_No,'-',LocationID,'-',TranscationId) as pk,  Year_No, Order_No, LocationID, TranscationId, Startdate, ExpiredDate FROM mylocations \";\n\n// Step2: Connect on_update event hander\n$e[\"on_update\"] = array(\"update_data\", null, false);\n$g-&gt;set_events($e);\n\n// Step3: In handler, split the PK with your separator, and execute custom UPDATE query\nfunction update_data($data)\n{\n        list($Year_No,$Order_No,$LocationID,$TranscationId) = explode(\"-\",$data[\"pk\"]);\n\n        $s = array();\n        foreach($data[\"params\"] as $k=&gt;$v)\n        {\n                $s[] = \"$k = '$v'\";\n        }\n        $s = implode(\",\",$s);\n\n        $w = \"Year_No=$Year_No and Order_No=$Order_No and LocationID=$LocationID and TranscationId=$TranscationId\";\n\n        mysql_query(\"UPDATE mylocations set $s WHERE $w\");\n}\n</code></pre>"},{"location":"master-detail-faqs.html#q-how-to-show-footer-row-in-subgrid","title":"Q) How to show footer row in subgrid?","text":"<p>In subgrid_detail, do following config.</p> <pre><code>$grid[\"footerrow\"] = true;\n$g-&gt;set_options($grid);\n\n$e[\"js_on_load_complete\"] = \"subgrid_onload\";\n$g-&gt;set_events($e);\n</code></pre> <p>In parent grid, put function to fill subgrid footer</p> <pre><code>&lt;script&gt;\n    var subgrid_onload = function () {\n            var grid = $(\"td.subgrid-data &gt; .tablediv &gt; div\").attr(\"id\").replace(\"gbox_\",\"\");\n            grid = jQuery(\"#\"+grid);\n\n            // sum of displayed result\n            sum = grid.jqGrid('getCol', 'total', false, 'sum');\n\n            c = grid.jqGrid('getCol', 'id', false, 'sum');\n            grid.jqGrid('footerData','set', {id: 'Sum:' + c, total: 'Total: '+sum});\n        };\n&lt;/script&gt;\n</code></pre>"},{"location":"master-detail-faqs.html#q-how-to-reload-parent-after-new-record-added-in-subgrid","title":"Q) How to reload parent after new record added in subgrid ?","text":"<p>Following config in subgrid_detail will reload parent when new record is inserted in detail grid. Reloading parent will make subgrid hidden again.</p> <p>In subgrid_detail php file, just add this line in grid options.</p> <pre><code>$grid[\"add_options\"][\"afterSubmit\"] = \"function(){jQuery('#list1').trigger('reloadGrid',[{page:1}]); return [true, ''];}\";\n</code></pre> <p>where list1 is parent list id.</p>"},{"location":"master-detail-faqs.html#q-how-to-keep-subgrid-expanded-after-parent-grids-refresh","title":"Q) How to keep subgrid expanded after parent grid's refresh ?","text":"<p>Following JS code snippet will keep subgrid opened after parent's refresh. You can place this script with parent grid's code.</p> <p>PHP Part:</p> <pre><code>// reload previous expanded subgrids on load event\n$e[\"js_on_load_complete\"] = \"grid_onload\";\n$grid-&gt;set_events($e);\n</code></pre> <p>JS Part:</p> <pre><code>&lt;script&gt;\nvar scrollPosition = 0\nvar ids = new Array();\n\nfunction grid_onload()\n{\n    jQuery.each(ids, function (id,data) {\n        $(\"#list1\").expandSubGridRow(data);\n        jQuery(\"#list1\").closest(\".ui-jqgrid-bdiv\").scrollTop(scrollPosition);\n    });\n}\n\n// custom refresh button\njQuery(document).ready(function(){\n\n    jQuery('#list1').jqGrid('navButtonAdd', '#list1_pager',\n    {\n        'caption'      : 'Refresh',\n        'buttonicon'   : 'ui-icon-extlink',\n        'onClickButton': function()\n        {\n            ids = new Array();\n            $('tr:has(.sgexpanded)').each(function(){ids.push($(this).attr('id'))});\n            scrollPosition = jQuery(\"#list1\").closest(\".ui-jqgrid-bdiv\").scrollTop()\n            $(\"#list1\").trigger(\"reloadGrid\");\n        },\n        'position': 'last'\n    });\n});\n&lt;/script&gt;\n</code></pre>"},{"location":"master-detail-faqs.html#q-how-to-disable-subgrid-expansion-on-specific-row","title":"Q) How to disable subgrid expansion on specific row ?","text":"<p>Following snippet will remove subgrid from e.g. rowid 2</p> <pre><code>$opt[\"loadComplete\"] = \"function(){\n                                    var rowid=2;\n                                    jQuery('tr#'+rowid+' td[aria-describedby$=subgrid]').html('');\n                                    jQuery('tr#'+rowid+' td[aria-describedby$=subgrid]').unbind();\n                                    }\";\n// ...\n$g-&gt;set_options($opt);\n</code></pre>"},{"location":"master-detail-faqs.html#q-how-to-select-inserted-row-in-master-grid-and-refresh-the-detail-grid-for-linked-operations","title":"Q) How to select inserted row in master grid, and refresh the detail grid for linked operations?","text":"<p>Following add_options setting in master grid will SELECT the newly inserted row.</p> <pre><code>$opt[\"add_options\"][\"afterComplete\"] = \"function (response, postdata) { r = JSON.parse(response.responseText);\n                                                                        jQuery( document ).ajaxComplete(function() {\n                                                                            jQuery('#list1').setSelection(r.id);\n                                                                            jQuery( document ).unbind('ajaxComplete');\n                                                                            });\n                                                                        }\";\n$grid-&gt;set_options($opt);\n</code></pre> <p>If you wish to show highlight effect, you can include jquery ui script,</p> <pre><code>&lt;script src=\"//code.jquery.com/ui/1.10.4/jquery-ui.js\"&gt;&lt;/script&gt;\n</code></pre> <p>And have highlight code in afterComplete:</p> <pre><code>$opt[\"add_options\"][\"afterComplete\"] = \"function (response, postdata) { r = JSON.parse(response.responseText); jQuery('#'+r.id,'#list1').effect('highlight', {color:'yellow'}, 2000); }\";\n$grid-&gt;set_options($opt);\n</code></pre> <p>A condition that new record should come in grid list, You can sort grid to decending id, to show newly added record on top of grid.</p>"},{"location":"master-detail-faqs.html#q-how-to-refresh-parent-grid-on-subgrid-insertion","title":"Q) How to refresh parent grid on subgrid insertion?","text":"<p>Following code steps will refresh subgrid's parent on child grid insertion. It will also expand the last child subgrid after refresh.</p> <p>First, disable default refresh button of parent grid.</p> <pre><code>$grid-&gt;set_actions(array(\n                        \"refresh\"=&gt;false // will add a custom refresh button\n                        )\n                    );\n</code></pre> <p>Set on_load event handler for parent.</p> <pre><code>// reload previous expanded subgrids on load event\n$e[\"js_on_load_complete\"] = \"grid_onload\";\n$grid-&gt;set_events($e);\n</code></pre> <p>Put following script tag in parent grid.</p> <pre><code>&lt;script&gt;\nvar scrollPosition = 0\nvar ids = new Array();\n\n// expand last child grid on load\nfunction grid_onload()\n{\n    jQuery.each(ids, function (id,data) {\n        $(\"#list1\").expandSubGridRow(data);\n        jQuery(\"#list1\").closest(\".ui-jqgrid-bdiv\").scrollTop(scrollPosition);\n    });\n}\n\nfunction reload_parent()\n{\n    ids = new Array();\n    $('tr:has(.sgexpanded)').each(function(){ids.push($(this).attr('id'))});\n    scrollPosition = jQuery(\"#list1\").closest(\".ui-jqgrid-bdiv\").scrollTop()\n    $(\"#list1\").trigger(\"reloadGrid\");\n}\n\n// custom refresh button\njQuery(document).ready(function(){\n\n    jQuery('#list1').jqGrid('navButtonAdd', '#list1_pager',\n    {\n        'caption'      : 'Refresh',\n        'buttonicon'   : 'ui-icon-extlink',\n        'onClickButton': function()\n        {\n            reload_parent();\n        },\n        'position': 'last'\n    });\n});\n&lt;/script&gt;\n</code></pre> <p>In child subgrid, set afterSubmit to call reload_parent() after insert.</p> <pre><code>$grid[\"add_options\"][\"afterSubmit\"] = \"function(){ reload_parent(); return [true, ''];}\";\n</code></pre>"},{"location":"master-detail-faqs.html#q-how-to-enable-cell-edit-on-double-click-and-functional-on-master-detail-grid","title":"Q) How to enable cell edit on double click and functional on master-detail grid?","text":"<p>Adding following options will make celledit work on double click and functional on master detail grid.</p> <pre><code>// celledit double click (master-detail) - list1 is grid id\n$opt[\"cellEdit\"] = true;\n$opt[\"beforeSelectRow\"] = \"function(rowid) { if (jQuery('#list1').jqGrid('getGridParam','selrow') != rowid) { jQuery('#list1').jqGrid('resetSelection'); jQuery('#list1').setSelection(rowid); } return false; }\";\n$opt[\"ondblClickRow\"] = \"function (rowid, iRow,iCol) { jQuery('#list1').editCell(iRow, iCol, true); }\";\n\n$grid-&gt;set_options($opt);\n</code></pre> <p>Refer demos/master-detail/excelview-detail.php</p>"},{"location":"master-detail-faqs.html#q-how-can-i-set-the-selected-row-first-row-on-load-page","title":"Q) How can I set the selected row (first row) on load page?","text":"<p>Following config will select the first row of grid on load event. You can customize as per your need.</p> <p>PHP:</p> <pre><code>$e[\"js_on_load_complete\"] = \"grid_onload\";\n$grid-&gt;set_events($e);\n</code></pre> <p>JS:</p> <pre><code>function grid_onload(ids)\n{\n    // get row ids from grid (with id: list1)\n    var ids = $(\"#list1\").jqGrid('getDataIDs');\n    setTimeout( function(){ jQuery('#list1').jqGrid('setSelection', ids[0], true); },100);\n}\n</code></pre> <p>Also check: https://www.gridphp.com/support/questions/select-row-on-load-page/</p>"},{"location":"master-detail-faqs.html#q-how-can-i-change-the-detail-title-when-i-select-a-row-from-master-grid","title":"Q) How can I change the detail title when I select a row from master grid?","text":"<p>On master grid, set onselect event.</p> <pre><code>$e[\"js_on_select_row\"] = \"do_onselect\";\n$grid-&gt;set_events($e);\n</code></pre> <p>and in html part add this script.</p> <pre><code>&lt;script&gt;\nfunction do_onselect(id)\n{\n    // get selected row company column value\n    var ctype = jQuery('#list1').jqGrid('getCell', id, 'company'); // where invdate is column name\n\n    // set company name in detail grid caption\n    jQuery('#list2').jqGrid('setCaption','Company Details: ' + ctype);\n}\n&lt;/script&gt;\n</code></pre> <p>Also check: https://www.gridphp.com/support/questions/select-row-on-load-page/</p>"},{"location":"master-detail-faqs.html#q-how-can-hideshow-detail-grid-on-selecting-a-row-from-master-grid","title":"Q) How can hide/show detail grid on selecting a row from master grid?","text":"<p>On master grid, set onselectrow event. If gender is male, it will hide detail grid otherwise show it. (where list1 is master, list2 is detail)</p> <pre><code>$opt[\"onSelectRow\"] = \"function(id){\n                        var gid = jQuery('#list1').jqGrid('getCell', id, 'gender');\n                        if (gid == 'male')\n                            $('#list2').jqGrid('setGridState', 'hidden');\n                        else\n                            $('#list2').jqGrid('setGridState', 'visible');\n                        }\";\n</code></pre>"},{"location":"master-detail-grid.html","title":"Master Detail Grid","text":""},{"location":"master-detail-grid.html#master-detail-grid","title":"Master Detail Grid","text":"<p>Following params will enable detail grid, and by default 'id' (PK) of parent is passed to detail grid. (see master-detail.php)</p> <pre><code>$opt[\"detail_grid_id\"] = \"list2\";\n</code></pre> <p>In order to invoke multiple detail grid, you can pass grid identifier in this way.</p> <pre><code>$opt[\"detail_grid_id\"] = \"list2,list3,list4\";\n</code></pre> <p>To extra params passed to detail grid, column name comma separated</p> <pre><code>$opt[\"subgridparams\"] = \"gender,company\";\n$g-&gt;set_options($opt);\n\n...\n...\n\n# To read passed params in detail grid code\n$company = $_GET[\"company\"];\n</code></pre>"},{"location":"master-detail-grid.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/master-detail/master-detail.php</code></li> </ul>"},{"location":"misc-faqs.html","title":"Misc FAQs","text":""},{"location":"misc-faqs.html#misc-faqs","title":"Misc FAQs","text":""},{"location":"misc-faqs.html#q-is-it-possible-to-load-the-grid-without-any-data-until-the-first-search-filter-is-triggered","title":"Q) Is it possible to load the grid without any data until the first search filter is triggered?","text":"<p>To start with blank grid, set:</p> <pre><code>$opt[\"datatype\"] = \"local\";\n$opt[\"loadComplete\"] = \"function(){ $('#list1').jqGrid('setGridParam',{datatype : 'json'}); \n                                    $('#div_no_record_list1').html('Please use search filters to show results'); }\";\n\ng-&gt;set_options($opt);\n</code></pre> <p>where <code>list1</code> is grid id.</p>"},{"location":"misc-faqs.html#q-performance-of-large-tables-in-grid-4-php","title":"Q) Performance of large tables in Grid 4 PHP?","text":"<p>Performance of loading data in grid consist of 2 parts.</p> <p>1) Client side: This is usually due to browser rendering capability of large html table, and JS engine that fill html. This can be improved by enabling virtual scrolling of grid. It loads data only when it is required by scrolling.</p> <p>As per docs, When enabled, the pager elements are disabled and we can use the vertical scrollbar to load data.</p> <pre><code>$opt[\"rowNum\"] = 50;\n$opt[\"scroll\"] = true;\n$g-&gt;set_options($opt);\n</code></pre> <p>2) Server side: This depends on database optimization factors, such as indexes, usage of 'like' queries etc. Best approach to optimize is to create indexes of your most searchable fields and avoid '%blah%' contains query which never use indexes in mysql. After creating indexes, you can try SELECT queries in phpmyadmin and track loading time. If gridphp loading time is still slow, drop me a message with your SQL and i'll check the internals.</p>"},{"location":"misc-faqs.html#q-how-to-use-gridphp-with-concurrent-users","title":"Q) How to use gridphp with concurrent users?","text":"<p>First solution is to use excel-view (cellEdit) mode. In this way, only the changed cell is submitted to server and not the whole row data. You can refer demos/appearence/excel-view.php for working demo.</p> <p>Second, If you want application based row level locking in grid:</p> <p>1) Introduce a new field 'last_modified', make it hidden on grid and editable. It will store the timestamp of row update. 2) Implement an on_update event handler and check if:     i) Fetch the edited row db table row, using select query     i) Check if posted back 'last_modified' value is different from the one in database against same row id     ii) If Yes, You can show phpgrid_error('Already edited') otherwise, go with the update.</p> <p>Working demo code: http://pastebin.com/Ds4WrD4z</p>"},{"location":"misc-faqs.html#q-how-to-show-some-custom-success-message-after-bulk-update","title":"Q) How to show some custom success message after bulk update?","text":"<p>Now you can push custom html messages from bulk edit handler. Instead of 'records updated' message, you can have your custom message. This only works with custom bulk-edit.</p> <pre><code>function update_data($data)\n{\n    // If bulk operation is requested, (default otherwise)\n    if ($data[\"params\"][\"bulk\"] == \"set-desc\")\n    {\n        $selected_ids = $data[\"id\"]; // e.g. the selected values from grid 5,7,14 (where \"id\" is field name of first col)\n        $str = $data[\"params\"][\"data\"];\n\n        // here you can code your logic to do bulk processing\n        mysql_query(\"UPDATE invheader SET note = '$str' WHERE id IN ($selected_ids)\");\n        phpgrid_msg(\"Download Zip: &lt;a target='_blank' href='http://google.com'&gt;http://google.com&lt;/a&gt;\",0);\n        die;\n    }\n}\n</code></pre> <p>first param is message, second is autoclose (0/1).</p>"},{"location":"misc-faqs.html#q-purchasing-a-license-is-a-one-time-payment-or-monthly","title":"Q) Purchasing a license is a one time payment or monthly?","text":"<p>It's a one time fee that includes a limited period of subscription for updates and technical support. If the subscription period expires, the product will keep working as before. However for new updates and technical support you will be required to renew the license.</p>"},{"location":"misc-faqs.html#q-how-to-pay-with-paypal-im-always-redirected-to-2checkout-and-i-dont-have-a-visa-card","title":"Q) How to pay with Paypal? I'm always redirected to 2Checkout, and I don't have a VISA-card.","text":"<p>When you visit 2checkout page, there is paypal option in last step of payment page. See image.</p> <p></p>"},{"location":"misc-faqs.html#q-how-to-set-local-timezone-in-date-operations","title":"Q) How to set local timezone in date operations?","text":"<p>This can be set by php default function. For more refer php docs.</p> <pre><code>date_default_timezone_set('Asia/Karachi');\n</code></pre>"},{"location":"misc-faqs.html#q-how-to-convert-db-stored-utc-time-to-local-time","title":"Q) How to convert (db stored) UTC time to Local time?","text":"<p>This can be done by using mysql convert_tz function in query.</p> <pre><code>// you can provide custom SQL query to display data - convert_tz for local time\n$g-&gt;select_command = \"SELECT i.id, CONVERT_TZ(invdate,'+00:00','+5:00') as invdate , c.name,\n                        i.note, i.total, i.closed FROM invheader i\n                        INNER JOIN clients c ON c.client_id = i.client_id\";\n</code></pre>"},{"location":"misc-faqs.html#q-how-to-use-multiselect-filter","title":"Q) How to use multiselect filter?","text":"<p>Step1: Include js/css files</p> <pre><code>&lt;link rel=\"stylesheet\" href=\"http://www.erichynds.com/examples/jquery-ui-multiselect-widget/jquery.multiselect.css\"&gt;\n&lt;link rel=\"stylesheet\" href=\"http://www.erichynds.com/examples/jquery-ui-multiselect-widget/jquery.multiselect.filter.css\"&gt;\n&lt;script src=\"http://www.erichynds.com/examples/jquery-ui-multiselect-widget/src/jquery.multiselect.js\"&gt;&lt;/script&gt;\n&lt;script src=\"http://www.erichynds.com/examples/jquery-ui-multiselect-widget/src/jquery.multiselect.filter.js\"&gt;&lt;/script&gt;\n</code></pre> <p>Step2: Set search type for multiselect filter column</p> <pre><code>// multi-select in search filter\n$col[\"stype\"] = \"select-multiple\";\n$col[\"searchoptions\"][\"value\"] = $str;\n</code></pre> <p>Refer: demos/integration/multiselect-filter.php</p>"},{"location":"misc-faqs.html#q-how-to-load-grid-based-on-_post-data-from-other-page","title":"Q) How to load grid based on $_POST data from other page?","text":"<p>The grid is loaded with 2 server calls.</p> <p>1) load the columns of grid. 2) do an ajax call, to load data of grid.</p> <p>Now, if you want to pass data from external form, it is available for step1. But not there in 2nd ajax call, as it is not posted. Solution is to put the POST variable in session and use it from session for step2.</p> <p>e.g.</p> <pre><code>if (!empty($_POST[\"personid\"]))\n{\n    $_SESSION[\"personid\"] = $_POST[\"personid\"];\n}\n$pid = $_SESSION[\"personid\"];\n</code></pre> <p>and use <code>$pid</code> in your SQL.</p>"},{"location":"misc-faqs.html#q-how-to-save-data-in-grid-using-external-form","title":"Q) How to save data in grid using external form?","text":"<p>You can apply following JS function on click event of external form. You need to change POST data request['column_name'] = 'col_value'; in javascript code, '#list1' is grid id in this example.</p> <pre><code>function updateData()\n{\n    // call ajax to update date in db\n    var request = {};\n    request['oper'] = 'edit';\n\n    // data to POST\n    request['id'] = '1';\n    request['company'] = 'test company';\n    var grid = jQuery('#list1');\n\n    jQuery.ajax({\n        url: grid.jqGrid('getGridParam','url'),\n        dataType: 'html',\n        data: request,\n        type: 'POST',\n        error: function(res, status) {\n            jQuery.jgrid.info_dialog(jQuery.jgrid.errors.errcap,'&lt;div class=\\\"ui-state-error\\\"&gt;'+ res.responseText +'&lt;/div&gt;',\n                    jQuery.jgrid.edit.bClose,{buttonalign:'right'});\n        },\n        success: function( data ) {\n            // reload grid for data changes\n            grid.jqGrid().trigger('reloadGrid',[{jqgrid_page:1}]);\n        }\n    });\n}\n</code></pre>"},{"location":"misc-faqs.html#q-how-to-set-custom-mesage-when-no-records-are-found","title":"Q) How to set custom mesage when no records are found?","text":"<p>You can set following JS before echo $out.</p> <pre><code>&lt;script&gt;\njQuery.jgrid.defaults.emptyrecords = \"There are no records for your selection\";\n&lt;/script&gt;\n\n&lt;div&gt;\n&lt;?php echo $out?&gt;\n&lt;/div&gt;\n</code></pre> <p>^ Top</p>"},{"location":"multiselect-filter.html","title":"Multiselect Filter","text":""},{"location":"multiselect-filter.html#multiselect-filter","title":"Multiselect Filter","text":"<p>Step1: Include JS / CSS files required to have this feature. Make sure you include JS files after jQuery JS inclusion.</p> <pre><code>&lt;link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-multiselect-widget/1.17/jquery.multiselect.css\"&gt;\n&lt;link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-multiselect-widget/1.17/jquery.multiselect.filter.css\"&gt;\n&lt;script src=\"https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-multiselect-widget/1.17/jquery.multiselect.js\"&gt;&lt;/script&gt;\n&lt;script src=\"https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-multiselect-widget/1.17/jquery.multiselect.filter.js\"&gt;&lt;/script&gt;\n</code></pre> <p>Step2:</p> <p>To have multi-select filter in search bar, add following properties with desired column:</p> <pre><code>// multi-select in search filter\n$col[\"stype\"] = \"select-multiple\";\n$col[\"searchoptions\"][\"value\"] = $str; // e.g. $str = \"key1:value1;key2:value2;key3:value3\"\n</code></pre> <p>It will replace search text box to multi-select filter for grid column <code>name</code></p> <pre><code>$col = array();\n$col[\"title\"] = \"Name\";\n$col[\"name\"] = \"name\";\n\n// this will prepare (key:value) option list for dropdown filters\n$str = $g-&gt;get_dropdown_values(\"select distinct name as k, name as v from clients\");\n\n// multi-select in search filter\n$col[\"stype\"] = \"select-multiple\";\n$col[\"searchoptions\"][\"value\"] = $str;\n\n$cols[] = $col;\n</code></pre> <p>If your column contains foreign key data (like client_id) then implementation will look like this:</p> <pre><code>$col = array();\n$col[\"title\"] = \"Client\";\n$col[\"name\"] = \"client_id\";\n$col[\"dbname\"] = \"invheader.client_id\";\n$col[\"width\"] = \"100\";\n\n// this will prepare (key:value) option list for dropdown filters\n$str = $g-&gt;get_dropdown_values(\"select distinct client_id as k, name as v from clients limit 10\");\n\n// in edit mode render as select\n$col[\"edittype\"] = \"select\";\n$col[\"editoptions\"] = array(\"value\"=&gt;\":;\".$str);\n\n// multi-select in search filter\n$col[\"stype\"] = \"select-multiple\";\n$col[\"searchoptions\"][\"value\"] = $str;\n\n$cols[] = $col;\n</code></pre> <p></p>"},{"location":"multiselect-filter.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/integrations/multiselect-filter.php</code></li> </ul>"},{"location":"responsive-design.html","title":"Responsive Design","text":""},{"location":"responsive-design.html#responsive-design","title":"Responsive Design","text":"<p>You can define which columns to show or hide based on screen resolution. Currently it uses following starting breakpoints.</p> <pre><code>xs - Extra Small devices (320px)\nsm - Small devices (544px)\nmd - Medium devices (768px)\nlg - Large devices (992px)\nxl - Extra Large devices (1200px)\n</code></pre> <p>By default it will auto hide columns from end based on screen size.</p> <pre><code>$opt[\"responsive\"] = true;\n...\n$g-&gt;set_options($opt);\n</code></pre> <p>To override and make a column visible on small devices and above, you can set:</p> <pre><code>$col[\"visible\"] = \"sm+\";\n</code></pre> <p>Complete column settings will be like following:</p> <pre><code>$col = array();\n$col[\"title\"] = \"Id\";\n$col[\"name\"] = \"id\";\n$col[\"width\"] = \"20\";\n$col[\"editable\"] = false;\n$col[\"visible\"] = \"sm+\";\n$cols[] = $col;\n</code></pre> <p>You can also specify certain screen sizes for a column. Following column will be shown on XS, SM and MD screen sizes.</p> <pre><code>$col[\"visible\"] = array(\"xs\",\"sm\",\"md\");\n</code></pre> <p>You can always show/hide certain columns by Column Chooser.</p> <p></p> <p>Below small devices screen sizes, It changes operation toolbar to 3 line toolbar.</p> <p></p> <p>And display of add/edit/view dialogs are transposed as well.</p> <p> </p>"},{"location":"responsive-design.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/responsive.php</code></li> </ul>"},{"location":"rss-news-reader.html","title":"Rss news reader","text":""},{"location":"rss-news-reader.html#rss-news-reader","title":"RSS News Reader","text":""},{"location":"search.html","title":"Search","text":""},{"location":"search.html#search","title":"Search","text":"<p>Grid allows variety of different options to make search feature more usable.</p>"},{"location":"search.html#autofilter-toolbar","title":"Autofilter toolbar","text":"<p>You can enable it by setting:</p> <pre><code>$g-&gt;set_actions(array(\n                        // ...\n                        \"autofilter\" =&gt; true\n                        // ...\n                    )\n                );\n</code></pre> <p>By default it will be hidden and once you set <code>xs+</code> autofilter will come back on extra small and onwards.</p> <pre><code>$opt[\"search_options\"][\"autofilter\"] = \"xs+\"; // xs+, sm+, md+\n$g-&gt;set_options($opt);\n</code></pre> <p></p>"},{"location":"search.html#search-dialog","title":"Search Dialog","text":"<p>Basic search dialog can be enabled by <code>search</code> key in set_actions function. Possible values are <code>simple</code>, <code>advance</code></p> Values Description <code>simple</code> Single column search dialog <code>advance</code> Multi column search with AND / OR option <code>group</code> Multi column search with multiple AND / OR groups <pre><code>$g-&gt;set_actions(array(\n                        // ...\n                        \"search\" =&gt; \"advance\"\n                        // ...\n                    )\n                );\n</code></pre> <p></p>"},{"location":"search.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/search/search-group.php</code></li> </ul>"},{"location":"search.html#search-templates","title":"Search Templates","text":"<p>You can also set predefined search templates using grid options.</p> <pre><code>// Define predefined search templates\n$opt[\"search_options\"][\"tmplNames\"] = array(\"Template1\", \"Template2\");\n$opt[\"search_options\"][\"tmplFilters\"] = array(\n    array(\n        \"groupOp\" =&gt; \"AND\",\n        \"rules\" =&gt; array (\n                        array(\"field\"=&gt;\"name\", \"op\"=&gt;\"cn\", \"data\"=&gt;\"Maria\"),\n                        array(\"field\"=&gt;\"closed\", \"op\"=&gt;\"cn\", \"data\"=&gt;\"No\"),\n                        )\n    ),\n    array(\n        \"groupOp\" =&gt; \"AND\",\n        \"rules\" =&gt; array (\n                        array(\"field\"=&gt;\"total\", \"op\"=&gt;\"gt\", \"data\"=&gt;\"50\")\n                        )\n    )\n);\n\n$g-&gt;set_options($opt);\n</code></pre> <p></p>"},{"location":"search.html#resources_1","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/search/search-template.php</code></li> </ul>"},{"location":"search.html#search-external-form","title":"Search External Form","text":"<p>For further customizations, you can create an custom HTML form and connect it to datagrid search javascript api.</p> <p></p>"},{"location":"search.html#resources_2","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/search/search-form.php</code></li> </ul>"},{"location":"search.html#search-on-load","title":"Search on Load","text":"<p>Following config will enable search on load. Initialize search with <code>name</code> field equal to <code>eq</code> 'Client 1'</p> <pre><code>$sarr = &lt;&lt;&lt; SEARCH_JSON\n{\n    \"groupOp\":\"AND\",\n    \"rules\":[\n      {\"field\":\"name\",\"op\":\"eq\",\"data\":\"Client 1\"}\n     ]\n}\nSEARCH_JSON;\n\n$opt[\"search\"] = true;\n$opt[\"postData\"] = array(\"filters\" =&gt; $sarr );\n</code></pre> <p>If you wish to persist search settings on page reload:</p> <pre><code>$opt[\"persistsearch\"] = true;\n</code></pre>"},{"location":"search.html#resources_3","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/search/search-onload.php</code></li> </ul>"},{"location":"search.html#search-based-on-url-parameters","title":"Search based on URL parameters","text":"<p>You can filter datagrid based on URL parameter as well. Url format is {gridid}_{colname}={value} e.g. page.php?grid_id=list1&amp;filter_closed=1 will filter grid with id <code>list1</code> on page.php with column name <code>closed</code> to <code>1</code> You can add multiple filtering (AND) conditions as shown in image.</p> <p></p> <p>To have a numeric range filter, (total &gt; 10) you can set e.g. ?grid_id=list1&amp;filter_total=&gt;10</p>"},{"location":"search.html#resources_4","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/search/search-onload-url.php</code></li> </ul>"},{"location":"search.html#show-hide-columns-based-on-url-parameters","title":"Show / Hide columns based on URL parameters","text":"<p>You can show or hide certain column based on URL parameter as well. Url format is {gridid}_showcols={col1},{col2} or {gridid}_hidecols={col1},{col2}</p> <p>e.g. <code>page.php?list1_showcols=id,invdate,note&amp;list1_hidecols=total</code></p> <p>This will show columns with name <code>id</code>,<code>invdate</code>,<code>note</code> (if defined and hidden) and hide column name <code>total</code> where <code>list1</code> is grid id on page.php.</p>"},{"location":"search.html#useful-js-search-events","title":"Useful JS Search Events","text":"<p>You can also use following events to perform custom operation after search.</p> <pre><code>// invoked after toolbar search\n$opt[\"autofilter_options\"][\"afterSearch\"] = \"function(){alert('after search toolbar');}\";\n\n// invoked after dialog search\n$opt[\"search_options\"][\"onSearch\"] = \"function(){alert('after search dialog');}\";\n</code></pre>"},{"location":"selecting-columns.html","title":"Selecting Columns","text":""},{"location":"selecting-columns.html#selecting-columns","title":"Selecting Columns","text":"<p>By default, when we define the <code>-&gt;table</code> property, it displays all the columns of table. </p>"},{"location":"selecting-columns.html#customizing-all-columns","title":"Customizing All Columns","text":"<p>We can pick certain columns to be displayed on grid by using <code>-&gt;set_columns($cols)</code> function.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Id\"; // caption of column, can use HTML tags too\n$col[\"name\"] = \"client_id\"; // grid column name, same as db field or alias from sql\n$col[\"width\"] = \"20\"; // width on grid\n$col[\"editable\"] = true;\n$cols[] = $col;\n\n$col = array();\n$col[\"title\"] = \"Name\"; // caption of column, can use HTML tags too\n$col[\"name\"] = \"name\"; // grid column name, same as db field or alias from sql\n$col[\"width\"] = \"40\"; // width on grid\n$col[\"editable\"] = true;\n$cols[] = $col;\n\n$col = array();\n$col[\"title\"] = \"Gender\"; // caption of column, can use HTML tags too\n$col[\"name\"] = \"gender\"; // grid column name, same as db field or alias from sql\n$col[\"width\"] = \"60\"; // width on grid\n$col[\"editable\"] = true;\n$cols[] = $col;\n\n// pass the cooked columns to grid\n$g-&gt;set_columns($cols);\n</code></pre>"},{"location":"selecting-columns.html#customizing-desired-columns","title":"Customizing Desired Columns","text":"<p>If you want to customize any specific column properties, and let other columns be displayed from table definition, you can pass 2nd argument of <code>set_columns($cols,true)</code> to <code>true</code>.</p> <pre><code>$col = array();\n$col[\"name\"] = \"company\";\n$col[\"edittype\"] = \"textarea\";\n$cols[] = $col;\n\n$g-&gt;set_columns($cols,true);\n</code></pre> <p>Only column with name 'company' will be changed to textarea and rest table column will be displayed as they were before.</p> <p>NOTE: The first column must have unique data (usually PK) in order to work properly. It is required to identify and perform row wise operations. You can make it hidden in grid if you wish. See <code>hidden</code> property in later section for more.</p>"},{"location":"selecting-columns.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/image.php</code></li> </ul>"},{"location":"setup.html","title":"Setup","text":""},{"location":"setup.html#setup","title":"Setup","text":""},{"location":"setup.html#requirements","title":"Requirements","text":"<p>On server side, we need:</p> <p>1) A Webserver running PHP v5.6+ (v5.6 and onwards)</p> <p>2) Database server (MySql, SQL Server, Oracle, SQLite or any other you use)</p> <p>On client side, we have tested it on famous browsers of Windows, MacOS and Linux.</p>"},{"location":"setup.html#installing-demos-using-web-installer","title":"Installing Demos using Web Installer","text":"<p>1) Extract the downloaded product archive in web root. e.g. www/gridphp</p> <p>2) Open it in browser to run installer. e.g. http://localhost/gridphp and following the intallation steps.</p>"},{"location":"setup.html#installing-demos-manually","title":"Installing Demos Manually","text":"<p>1) Execute \"demos/sample-db/database-mysql.sql\" on a Mysql Database. It will create 'griddemo' database. For SQL Server installation same process can be followed using database-mssql.sql file.</p> <p>2) Place all files in a directory on the web server. e.g. \".../www/gridphp/\"</p> <p>3) Rename config.sample.php to config.php, and update database config. e.g.</p> <pre><code>define(\"PHPGRID_DBTYPE\",\"mysqli\");\ndefine(\"PHPGRID_DBHOST\",\"localhost\");\ndefine(\"PHPGRID_DBUSER\",\"root\");\ndefine(\"PHPGRID_DBPASS\",\"\");\ndefine(\"PHPGRID_DBNAME\",\"griddemo\");\n\n// It will work in normal cases, unless you change lib folder location\ndefine(\"PHPGRID_LIBPATH\",dirname(__FILE__).DIRECTORY_SEPARATOR.\"lib\".DIRECTORY_SEPARATOR);\n</code></pre> <p>4) Run the product demos in browser. e.g. http://localhost/gridphp/index.php</p>"},{"location":"setup.html#integration-in-your-project","title":"Integration in your Project","text":"<p>To integration in your app, copy 'lib' folder to your project. You need to consider 3 things.</p> <p>1) Set DB config</p> <pre><code>$db_conf = array();\n$db_conf[\"type\"] = \"mysqli\";\n$db_conf[\"server\"] = PHPGRID_DBHOST; // or you mysql ip\n$db_conf[\"user\"] = PHPGRID_DBUSER; // username\n$db_conf[\"password\"] = PHPGRID_DBPASS; // password\n$db_conf[\"database\"] = PHPGRID_DBNAME; // database\n\n// pass connection array to jqgrid()\n$g = new jqgrid($db_conf);\n</code></pre> <p>2) The folder <code>../../lib</code> will be replaced by path where you place <code>lib</code> folder (if changed)</p> <pre><code>&lt;link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"../../lib/js/themes/start/jquery-ui.custom.css\"&gt;&lt;/link&gt;\n&lt;link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"../../lib/js/jqgrid/css/ui.jqgrid.css\"&gt;&lt;/link&gt;\n&lt;script src=\"../../lib/js/jquery.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/i18n/grid.locale-en.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/jqgrid/js/jquery.jqGrid.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"../../lib/js/themes/jquery-ui.custom.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>3) Update include path where you place <code>lib/inc/</code> folder (if changed)</p> <pre><code>include(\"../../lib/inc/jqgrid_dist.php\");\n$g = new jqgrid($db_conf);\n</code></pre>"},{"location":"setup.html#upgrading-from-older-version","title":"Upgrading from older version","text":"<p>To upgrade you just need to update files of two folder <code>lib/inc</code> &amp; <code>lib/js</code>.</p> <ul> <li>Take a backup of current <code>lib/inc</code> &amp; <code>lib/js</code> folders.</li> <li>Replace <code>lib/inc</code> &amp; <code>lib/js</code> from the new version archive to your existing datagrid implementation.  </li> <li>You may need to clear browser cache to remove the effect of previous JS and CSS files.</li> </ul> <p>Same process applies when upgrading from free version to full version.</p>"},{"location":"setup.html#upgrading-to-v28-from-previous-versions","title":"Upgrading to v2.8 from previous versions","text":"<p>If you are using custom toolbar buttons, there a slight change required after upgrade.</p> <p>Previous implementation is to have JS code in following way:</p> <pre><code>jQuery(\"#list1\").jqGrid('navButtonAdd',\"#list1_pager\",{...});\njQuery(\"#list1\").jqGrid('navButtonAdd',\"#list1_pager\",{...});\n</code></pre> <p>In v2.8 and onwards, move this code inside a setTimeout() delay of 10ms:</p> <pre><code>setTimeout(()=&gt;{\n\n    jQuery(\"#list1\").jqGrid('navButtonAdd',\"#list1_pager\",{...});\n    jQuery(\"#list1\").jqGrid('navButtonAdd',\"#list1_pager\",{...});\n\n},10);\n</code></pre>"},{"location":"state-persistence.html","title":"State Persistence","text":""},{"location":"state-persistence.html#state-persistence","title":"State Persistence","text":"<p>Step1: Include JS / CSS files required to have this feature. Make sure you include JS files after jQuery JS inclusion.</p> <pre><code>&lt;!-- library for persistance storage --&gt;\n&lt;script src=\"//cdn.jsdelivr.net/jstorage/0.1/jstorage.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"//cdn.jsdelivr.net/json2/0.1/json2.min.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n&lt;script src=\"//cdn.jsdelivr.net/gh/gridphp/jqGridState@10b365046ebd687914855e807eb5f769277317d5/jqGrid.state.js\" type=\"text/javascript\"&gt;&lt;/script&gt;\n</code></pre> <p>Step2: Before displaying grid echo $out, set persistence options in script tag:</p> <pre><code>&lt;script&gt;\nvar opts_list1 = {\n    \"stateOptions\": {\n                storageKey: \"gridState-list1\",\n                columns: true, // remember column chooser settings\n                selection: true, // row selection\n                expansion: true, // subgrid expansion\n                filters: true, // filters\n                pager: true, // page number\n                order: true // field ordering\n    }\n};\n&lt;/script&gt;\n</code></pre> <ul> <li>Set true/false setting in JS object you want to keep persistence on page reload.</li> <li>If you have single grid on page, <code>var opts</code> will also work. However it's better to use <code>var opts_&lt;gridid&gt;</code></li> <li>Option <code>storageKey</code> should be unique for each grid, otherwise settings will mix-up.</li> <li>It uses client side browser storage. To persist on server, refer demo code below.</li> </ul>"},{"location":"state-persistence.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/misc/persist-settings.php</code></li> </ul>"},{"location":"subgrid.html","title":"Subgrid","text":""},{"location":"subgrid.html#subgrid","title":"Subgrid","text":""},{"location":"subgrid.html#single-subgrid","title":"Single Subgrid","text":"<p>Setting <code>subGrid</code> to <code>true</code> will enable subgrid. When clicking <code>+</code> icon on parent grid, it will try to load url defined in <code>subgridurl</code>. By default 'rowid' (PK) of parent is passed. <code>subgridparams</code> holds comma sep. fields that will be POSTed from parent grid to subgrid. They can be read using $_POST in subgrid.</p> <pre><code>$opt[\"subGrid\"] = true;\n$opt[\"subgridurl\"] = \"subgrid_detail.php\";\n$opt[\"subgridparams\"] = \"name,gender,company\"; // no spaces b/w column names\n</code></pre> <p>On subgrid, data can be fetched and passed in SQL</p> <pre><code>$c_id = $_REQUEST[\"rowid\"];\n$g-&gt;select_command = \"SELECT concat(id,'-',num) as `key`, i.*\n                        FROM invlines i WHERE id = $c_id\";\n</code></pre> <p>For extra params passed from parent other than rowid (e.g. company), we need some persistent storage in session for ajax calls</p> <pre><code>if (!empty($_POST[\"company\"]))\n    $_SESSION[\"company\"] = $_POST['company'];\n$company = $_SESSION['company'];\n</code></pre>"},{"location":"subgrid.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/master-detail/subgrid.php</code></li> </ul>"},{"location":"subgrid.html#multiple-subgrid-at-same-level","title":"Multiple Subgrid at same level","text":"<p>To define multiple subgrid at same level, just render 2 grids in detail grid page. Rest process will be same as above subgrid.</p> <pre><code>$g = new jqgrid();\n// ...\n$out1 = $g-&gt;render('list1');\n\n$g = new jqgrid();\n// ...\n$out2 = $g-&gt;render('list2');\n\necho \"&lt;fieldset&gt;&lt;legend&gt;First Grid&lt;/legend&gt;$out&lt;/fieldset&gt;\";\necho \"&lt;fieldset&gt;&lt;legend&gt;Second Grid&lt;/legend&gt;$out2&lt;/fieldset&gt;\";\n</code></pre>"},{"location":"subgrid.html#resources_1","title":"Resources","text":"<ul> <li>Parent Grid Code</li> <li>Detail Grid Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/master-detail/multi-subgrid.php</code></li> </ul>"},{"location":"themes.html","title":"Themes","text":""},{"location":"themes.html#themes","title":"Themes","text":"<p>Instead of <code>redmond</code> in below css code, you can use any of the themes from following list:</p> <pre><code>&lt;link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"../../lib/js/themes/redmond/jquery-ui.custom.css\"&gt;&lt;/link&gt;\n</code></pre> <ul> <li>black-tie</li> <li>blitzer</li> <li>cupertino</li> <li>dark-hive</li> <li>dot-luv</li> <li>eggplant</li> <li>excite-bike</li> <li>flick</li> <li>hot-sneaks</li> <li>humanity</li> <li>le-frog</li> <li>mint-choc</li> <li>overcast</li> <li>pepper-grinder</li> <li>redmond</li> <li>smoothness</li> <li>south-street</li> <li>start</li> <li>sunny</li> <li>swanky-purse</li> <li>trontastic</li> <li>ui-darkness</li> <li>ui-lightness</li> <li>vader</li> </ul> <p>You can also have your customized theme (jqueryui.com/themeroller).</p> <p>Steps:</p> <ul> <li>Goto above link, adjust the theme colors</li> <li>Download the theme archive</li> <li>Create a new folder e.g. 'new-theme' in lib/js/themes\u00a0</li> <li>From archive copy image folder to your new-theme\u00a0</li> <li>From archive copy jquery-ui.min.css to your new-theme and rename as jquery-ui.custom.css</li> </ul>"},{"location":"themes.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/appearance/themes.php</code></li> </ul>"},{"location":"upload-files.html","title":"Upload Files","text":""},{"location":"upload-files.html#upload-files","title":"Upload Files","text":"<p>Step1: Define column with edittype 'file', and set uploading path in 'upload_dir' property.</p> <pre><code>// file upload column\n$col = array();\n$col[\"title\"] = \"Note\";\n$col[\"name\"] = \"note\";\n$col[\"width\"] = \"50\";\n$col[\"editable\"] = true;\n\n$col[\"edittype\"] = \"file\"; // render as file\n$col[\"upload_dir\"] = \"temp\"; // upload here\n\n$col[\"show\"] = array(\"list\"=&gt;false,\"edit\"=&gt;true,\"add\"=&gt;true); // only show in add/edit dialog\n$cols[] = $col;\n</code></pre> <p>Step2: To display uploaded file in grid, make a (non-db) virtual column.</p> <pre><code>$col = array();\n$col[\"title\"] = \"Image\";\n$col[\"name\"] = \"logo\";\n$col[\"width\"] = \"200\";\n$col[\"editable\"] = true;\n$col[\"default\"] = \"&lt;a href='http://jqgrid/dev/demos/dev/{note}' target='_blank'&gt;&lt;img height=100 src='http://jqgrid/dev/demos/dev/{note}'&gt;&lt;/a&gt;\";\n$col[\"show\"] = array(\"list\"=&gt;true,\"edit\"=&gt;false,\"add\"=&gt;false); // only show in listing\n$cols[] = $col;\n</code></pre> <p>You can also decide what to do when file already exist:</p> <pre><code>// prompt error\n$col[\"editrules\"] = array(\"ifexist\"=&gt;\"error\");\n\n// rename file e.g. file_1,file_2,file_3 etc (default)\n$col[\"editrules\"] = array(\"ifexist\"=&gt;\"rename\");\n\n// override file\n$col[\"editrules\"] = array(\"ifexist\"=&gt;\"override\");\n</code></pre> <p>To restrict uploaded files based on extension you can set:</p> <pre><code>$col[\"editrules\"][\"allowedext\"] = \"jpeg,jpg,png,bmp,gif\"; // comma separated list of extensions\n</code></pre> <p>To restrict uploaded files size you can set:</p> <pre><code>$col[\"editrules\"][\"allowedsize\"] = 3 * 1024 * 1024; // sets max allowed filesize to 3mb\n</code></pre> <p>To upload multiple files, you can set following. It uploads all selected files in specified folder and set comma separated file names in posted array field to be saved in db. One can use on_insert, on_update to separate them and save in separate table if required.</p> <pre><code>$col[\"editoptions\"][\"multiple\"] = \"multiple\";\n</code></pre> <p>Make sure you have configured following settings in php.ini OR using ini_set() function.  e.g. setting following in php.ini set 64 MB upload limit.</p> <pre><code>memory_limit = 64M\nupload_max_filesize = 64M\npost_max_size = 64M\n</code></pre> <p>More details can be checked here: https://stackoverflow.com/a/16102850/385377</p>"},{"location":"upload-files.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/editing/file-upload.php</code></li> </ul>"},{"location":"validation.html","title":"Validation","text":""},{"location":"validation.html#validation","title":"Validation","text":""},{"location":"validation.html#js-validation","title":"JS Validation","text":"<p>You can specify the validation rules required on each column. Possible options are mentioned below</p> <pre><code>$col[\"editrules\"] = array(\"required\"=&gt;true);\n$col[\"editrules\"] = array(\"number\"=&gt;true);\n$col[\"editrules\"] = array(\"email\"=&gt;true);\n$col[\"editrules\"] = array(\"date\"=&gt;true);\n$col[\"editrules\"] = array(\"minValue\"=&gt;5, \"maxValue\"=&gt;10);\n$col[\"editrules\"] = array(\"url\"=&gt;true);\n</code></pre> <p>The <code>date</code> validation will check input against format specified in datefmt option. It uses a PHP-like date formatting. Currently \"/\", \"-\", and \".\" are supported as date separators. Valid formats are: y,Y,yyyy for four digits year YY, yy for two digits year m,mm for months d,dd for days</p> <pre><code>$col[\"datefmt\"] = \"Y-m-d\";\n</code></pre>"},{"location":"validation.html#custom-js-validation","title":"Custom JS Validation","text":"<p>For custom validation function (be it ajax remote checking or complex regex), Follow following steps. For e.g. to check certain column value must be greater than 100:</p> <p>Step1: Define <code>custom_func</code> property for JS function</p> <pre><code>$col = array();\n$col[\"title\"] = \"Date\";\n$col[\"name\"] = \"invdate\";\n$col[\"width\"] = \"50\";\n$col[\"editable\"] = true;\n$col[\"editrules\"] = array(\"custom\"=&gt;true,\"custom_func\"=&gt;\"function(val,label){return my_validation(val,label);}\");\n$cols[] = $col;\n</code></pre> <p>Step2: Define JS callback function</p> <pre><code>&lt;script&gt;\nfunction my_validation(value,label)\n{\n    if (value &gt; 100)\n        return [true,\"\"];\n    else\n        return [false,label+\": Should be greater than 100\"];\n}\n&lt;/script&gt;\n</code></pre> <p>To validate some field 'onblur' JS event, set it in 'editoptions' and define JS callback function like above.</p> <pre><code>$col[\"editoptions\"] = array(\"onblur\"=&gt;\"validate_onblur(this)\");\n</code></pre>"},{"location":"validation.html#resources","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/editing/js-validation.php</code></li> </ul>"},{"location":"validation.html#server-validation","title":"Server Validation","text":"<p>If you want to validate that client does not already exist in database. Following code will prompt the \u2018already exist\u2019 message as data entry error.</p> <p>Step1: Define on_insert event handler 'add_client' for server validation.</p> <pre><code>$e[\"on_insert\"] = array(\"add_client\", null, true);\n$grid-&gt;set_events($e);\n</code></pre> <p>Step2: The helper function \u2018phpgrid_error\u2019 will display your server side validation message as error dialog.</p> <pre><code>function add_client($data)\n{\n    global $grid; // where $grid = new jqgrid(...);\n\n    $check_sql = \"SELECT count(*) as c from clients where LOWER(`name`) = '\".strtolower($data[\"params\"][\"name\"]).\"'\";\n\n    $rs = $grid-&gt;get_one($check_sql);\n\n    if ($rs[\"c\"] &gt; 0)\n        phpgrid_error(\"Client already exist in database\");\n\n    $grid-&gt;execute_query(\"INSERT INTO clients VALUES (null,'{$data[\"params\"][\"name\"]}','{$data[\"params\"][\"gender\"]}','{$data[\"params\"][\"company\"]}')\");\n}\n</code></pre>"},{"location":"validation.html#resources_1","title":"Resources","text":"<ul> <li>Sample Code</li> <li>See Live Demo</li> <li>You can check this demo in archive <code>demos/editing/server-validation.php</code></li> </ul>"},{"location":"wordpress-integration.html","title":"WordPress Integration","text":""},{"location":"wordpress-integration.html#wordpress-integration","title":"WordPress Integration","text":"<p>We've published a new simplified tutorial on how to integrate Grid 4 PHP Framework with WordPress Sites.  WordPress misses a comprehensive Editable Table, DataGrid and a CRUD solution, so we've integrated it to solve the problem.</p> <p></p> <p>It enables using most features of our Data Grid inside WordPress and much simpler than previous implementations.  Steps required to integrate are following:</p>"},{"location":"wordpress-integration.html#step-1-downloading-package","title":"Step 1: Downloading Package","text":"<p>Download Free version or Buy package from our website (if not already done) </p> <ul> <li>Move <code>lib</code> folder from package in your WordPress root directory </li> <li>Rename <code>lib</code> folder as <code>phpgrid</code></li> </ul> <p></p> <p>and inside this folder the contents should be:</p> <p></p>"},{"location":"wordpress-integration.html#step-2-code-snippet-plugin","title":"Step 2: Code Snippet Plugin","text":"<p>Install WordPress plugin <code>Code Snippets</code> from wordpress.org/plugins/code-snippets/ OR download from Github Repository and install manually.</p> <p></p>"},{"location":"wordpress-integration.html#step-3-adding-snippet","title":"Step 3: Adding Snippet","text":"<p>Goto admin panel and click Add Snippet as in image. Add any title you like and in code section, Copy paste the Sample Code Snippet:</p> <p>In code section of your WordPress Plugin shown below:</p> <p></p> <p>To customize the DataGrid widget:</p> <ol> <li>Change database configuration in the contructor and DataGrid code in the render() function.</li> <li>If want to show grid in admin area, uncomment admin_init, admin_enqueue_scripts hooks in constructor.</li> <li>In case of CSS conflict with Wordpress theme, adjust CSS at the end of render() function.</li> <li>In case of multiple datagrids, use unique class name for each grid.</li> <li>DataGrid Shortcode will be the same as Classname that can be used in post/pages. For e.g. in our demo [phpgrid_users] </li> </ol>"},{"location":"wordpress-integration.html#step-4-adding-shortcode","title":"Step 4: Adding Shortcode","text":"<p>In this code, we have created a shortcode here same as class name: [phpgrid_users] and we will now place it on page where we want to show our Datagrid.</p> <p></p>"},{"location":"wordpress-integration.html#result","title":"Result","text":"<p>Now Save the page and open / preview it, you will get the Datagrid.</p> <p></p> <p>WordPress featuring Sub-Grids:</p> <p></p>"},{"location":"wordpress-integration.html#datagrid-in-wordpress-backend","title":"DataGrid in WordPress Backend","text":"<p>Following steps will be required to make shortcode available in admin area \u2013 plugin development.</p> <p>Step1: Add admin_init &amp; admin_footer hook along with others.</p> <p></p> <p>Step2: Select \u2018Run Snippet everywhere\u2019 after snippet code block.</p> <p></p> <p>Step3: Call do_shortcode() function where you want to show datagrid.</p> <p></p> <p>Result:</p> <p></p> <p>You can create more snippets by copying code from package demos and assign new unique class name for each grid which can be placed on your page/post of WordPress.</p>"}]}